/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb;

import dev.brighten.antivpn.shaded.com.mongodb.BulkWriteRequestBuilder;
import dev.brighten.antivpn.shaded.com.mongodb.BulkWriteResult;
import dev.brighten.antivpn.shaded.com.mongodb.DBCollection;
import dev.brighten.antivpn.shaded.com.mongodb.DBObject;
import dev.brighten.antivpn.shaded.com.mongodb.InsertRequest;
import dev.brighten.antivpn.shaded.com.mongodb.WriteConcern;
import dev.brighten.antivpn.shaded.com.mongodb.WriteRequest;
import dev.brighten.antivpn.shaded.com.mongodb.assertions.Assertions;
import dev.brighten.antivpn.shaded.org.bson.types.ObjectId;
import java.util.ArrayList;
import java.util.List;

public class BulkWriteOperation {
    private static final String ID_FIELD_NAME = "_id";
    private final boolean ordered;
    private final DBCollection collection;
    private final List<WriteRequest> requests = new ArrayList<WriteRequest>();
    private Boolean bypassDocumentValidation;
    private boolean closed;

    BulkWriteOperation(boolean ordered, DBCollection collection) {
        this.ordered = ordered;
        this.collection = collection;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public void setBypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
    }

    public void insert(DBObject document) {
        Assertions.isTrue("already executed", !this.closed);
        if (document.get(ID_FIELD_NAME) == null) {
            document.put(ID_FIELD_NAME, new ObjectId());
        }
        this.addRequest(new InsertRequest(document, this.collection.getObjectCodec()));
    }

    public BulkWriteRequestBuilder find(DBObject query) {
        Assertions.isTrue("already executed", !this.closed);
        return new BulkWriteRequestBuilder(this, query, this.collection.getDefaultDBObjectCodec(), this.collection.getObjectCodec());
    }

    public BulkWriteResult execute() {
        Assertions.isTrue("already executed", !this.closed);
        this.closed = true;
        return this.collection.executeBulkWriteOperation(this.ordered, this.bypassDocumentValidation, this.requests);
    }

    public BulkWriteResult execute(WriteConcern writeConcern) {
        Assertions.isTrue("already executed", !this.closed);
        this.closed = true;
        return this.collection.executeBulkWriteOperation(this.ordered, this.bypassDocumentValidation, this.requests, writeConcern);
    }

    void addRequest(WriteRequest request) {
        Assertions.isTrue("already executed", !this.closed);
        this.requests.add(request);
    }
}

