/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb;

import dev.brighten.antivpn.shaded.com.mongodb.BasicDBList;
import dev.brighten.antivpn.shaded.com.mongodb.DBCallback;
import dev.brighten.antivpn.shaded.com.mongodb.DBCallbackFactory;
import dev.brighten.antivpn.shaded.com.mongodb.DBCollection;
import dev.brighten.antivpn.shaded.com.mongodb.DBCollectionObjectFactory;
import dev.brighten.antivpn.shaded.com.mongodb.DBObjectFactory;
import dev.brighten.antivpn.shaded.com.mongodb.DBRef;
import dev.brighten.antivpn.shaded.org.bson.BSONObject;
import dev.brighten.antivpn.shaded.org.bson.BasicBSONCallback;
import dev.brighten.antivpn.shaded.org.bson.types.BasicBSONList;
import dev.brighten.antivpn.shaded.org.bson.types.ObjectId;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultDBCallback
extends BasicBSONCallback
implements DBCallback {
    private final DBObjectFactory objectFactory;
    public static final DBCallbackFactory FACTORY = new DBCallbackFactory(){

        @Override
        public DBCallback create(DBCollection collection) {
            return new DefaultDBCallback(collection);
        }
    };

    public DefaultDBCallback(DBCollection collection) {
        this.objectFactory = collection != null ? collection.getObjectFactory() : new DBCollectionObjectFactory();
    }

    @Override
    public BSONObject create() {
        return this.objectFactory.getInstance();
    }

    @Override
    public BSONObject create(boolean array, List<String> path) {
        return array ? new BasicDBList() : this.objectFactory.getInstance(path != null ? path : Collections.emptyList());
    }

    @Override
    public void gotDBRef(String name, String namespace, ObjectId id) {
        this._put(name, new DBRef(namespace, id));
    }

    @Override
    public Object objectDone() {
        Iterator<String> iterator;
        String name = this.curName();
        BSONObject document = (BSONObject)super.objectDone();
        if (!(document instanceof BasicBSONList) && (iterator = document.keySet().iterator()).hasNext() && iterator.next().equals("$ref") && iterator.hasNext() && iterator.next().equals("$id")) {
            this._put(name, new DBRef((String)document.get("$db"), (String)document.get("$ref"), document.get("$id")));
        }
        return document;
    }
}

