/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.client.internal;

import dev.brighten.antivpn.shaded.com.mongodb.ClientEncryptionSettings;
import dev.brighten.antivpn.shaded.com.mongodb.MongoNamespace;
import dev.brighten.antivpn.shaded.com.mongodb.WriteConcern;
import dev.brighten.antivpn.shaded.com.mongodb.client.MongoClient;
import dev.brighten.antivpn.shaded.com.mongodb.client.MongoClients;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.Crypt;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.Crypts;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.SimpleMongoClients;
import dev.brighten.antivpn.shaded.com.mongodb.client.model.vault.DataKeyOptions;
import dev.brighten.antivpn.shaded.com.mongodb.client.model.vault.EncryptOptions;
import dev.brighten.antivpn.shaded.com.mongodb.client.vault.ClientEncryption;
import dev.brighten.antivpn.shaded.org.bson.BsonBinary;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonValue;
import java.io.Closeable;

public class ClientEncryptionImpl
implements ClientEncryption,
Closeable {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = MongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(SimpleMongoClients.create(this.keyVaultClient), options);
        this.options = options;
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions);
        MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
        this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }
}

