/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.client.internal;

import dev.brighten.antivpn.shaded.com.mongodb.AutoEncryptionSettings;
import dev.brighten.antivpn.shaded.com.mongodb.ClientEncryptionSettings;
import dev.brighten.antivpn.shaded.com.mongodb.MongoClientException;
import dev.brighten.antivpn.shaded.com.mongodb.MongoClientSettings;
import dev.brighten.antivpn.shaded.com.mongodb.MongoNamespace;
import dev.brighten.antivpn.shaded.com.mongodb.client.MongoClients;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.CollectionInfoRetriever;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.CommandMarker;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.Crypt;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.KeyManagementService;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.KeyRetriever;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.SimpleMongoClient;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.SimpleMongoClients;
import dev.brighten.antivpn.shaded.com.mongodb.crypt.capi.MongoCryptOptions;
import dev.brighten.antivpn.shaded.com.mongodb.crypt.capi.MongoCrypts;
import dev.brighten.antivpn.shaded.com.mongodb.internal.capi.MongoCryptHelper;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(SimpleMongoClient client, AutoEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), options.getSchemaMap())), new CollectionInfoRetriever(client), new CommandMarker(options.isBypassAutoEncryption(), options.getExtraOptions()), Crypts.createKeyRetriever(client, options.getKeyVaultMongoClientSettings(), options.getKeyVaultNamespace()), Crypts.createKeyManagementService(), options.isBypassAutoEncryption());
    }

    static Crypt create(SimpleMongoClient keyVaultClient, ClientEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), null)), Crypts.createKeyRetriever(keyVaultClient, false, options.getKeyVaultNamespace()), Crypts.createKeyManagementService());
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient defaultKeyVaultClient, MongoClientSettings keyVaultMongoClientSettings, String keyVaultNamespaceString) {
        boolean keyRetrieverOwnsClient;
        SimpleMongoClient keyVaultClient;
        if (keyVaultMongoClientSettings != null) {
            keyVaultClient = SimpleMongoClients.create(MongoClients.create(keyVaultMongoClientSettings));
            keyRetrieverOwnsClient = true;
        } else {
            keyVaultClient = defaultKeyVaultClient;
            keyRetrieverOwnsClient = false;
        }
        return Crypts.createKeyRetriever(keyVaultClient, keyRetrieverOwnsClient, keyVaultNamespaceString);
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient keyVaultClient, boolean keyRetrieverOwnsClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, keyRetrieverOwnsClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService() {
        return new KeyManagementService(Crypts.getSslContext(), 443, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
        return sslContext;
    }

    private Crypts() {
    }
}

