/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.client.internal;

import dev.brighten.antivpn.shaded.com.mongodb.MongoNamespace;
import dev.brighten.antivpn.shaded.com.mongodb.ReadConcern;
import dev.brighten.antivpn.shaded.com.mongodb.ReadPreference;
import dev.brighten.antivpn.shaded.com.mongodb.assertions.Assertions;
import dev.brighten.antivpn.shaded.com.mongodb.client.ClientSession;
import dev.brighten.antivpn.shaded.com.mongodb.client.ListIndexesIterable;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.MongoIterableImpl;
import dev.brighten.antivpn.shaded.com.mongodb.client.internal.OperationExecutor;
import dev.brighten.antivpn.shaded.com.mongodb.internal.operation.SyncOperations;
import dev.brighten.antivpn.shaded.com.mongodb.lang.Nullable;
import dev.brighten.antivpn.shaded.com.mongodb.operation.BatchCursor;
import dev.brighten.antivpn.shaded.com.mongodb.operation.ReadOperation;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecRegistry;
import java.util.concurrent.TimeUnit;

class ListIndexesIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListIndexesIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final Class<TResult> resultClass;
    private long maxTimeMS;

    ListIndexesIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this(clientSession, namespace, resultClass, codecRegistry, readPreference, executor, true);
    }

    ListIndexesIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor, boolean retryReads) {
        super(clientSession, executor, ReadConcern.DEFAULT, readPreference, retryReads);
        this.operations = new SyncOperations<BsonDocument>(namespace, BsonDocument.class, readPreference, codecRegistry, retryReads);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
    }

    @Override
    public ListIndexesIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListIndexesIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.operations.listIndexes(this.resultClass, this.getBatchSize(), this.maxTimeMS);
    }
}

