/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.event;

import dev.brighten.antivpn.shaded.com.mongodb.annotations.Immutable;
import dev.brighten.antivpn.shaded.com.mongodb.assertions.Assertions;
import dev.brighten.antivpn.shaded.com.mongodb.diagnostics.logging.Logger;
import dev.brighten.antivpn.shaded.com.mongodb.diagnostics.logging.Loggers;
import dev.brighten.antivpn.shaded.com.mongodb.event.CommandFailedEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.CommandListener;
import dev.brighten.antivpn.shaded.com.mongodb.event.CommandStartedEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.CommandSucceededEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Immutable
@Deprecated
public final class CommandEventMulticaster
implements CommandListener {
    private static final Logger LOGGER = Loggers.getLogger("protocol.event");
    private final List<CommandListener> commandListeners;

    public CommandEventMulticaster(List<CommandListener> commandListeners) {
        Assertions.notNull("commandListeners", commandListeners);
        Assertions.isTrue("All CommandListener instances are non-null", !commandListeners.contains(null));
        this.commandListeners = new ArrayList<CommandListener>(commandListeners);
    }

    public List<CommandListener> getCommandListeners() {
        return Collections.unmodifiableList(this.commandListeners);
    }

    @Override
    public void commandStarted(CommandStartedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandStarted(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandSucceeded(CommandSucceededEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandSucceeded(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void commandFailed(CommandFailedEvent event) {
        for (CommandListener cur : this.commandListeners) {
            try {
                cur.commandFailed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", cur), e);
            }
        }
    }
}

