/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.event;

import dev.brighten.antivpn.shaded.com.mongodb.assertions.Assertions;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ConnectionDescription;
import dev.brighten.antivpn.shaded.com.mongodb.event.CommandEvent;
import java.util.concurrent.TimeUnit;

public final class CommandFailedEvent
extends CommandEvent {
    private final long elapsedTimeNanos;
    private final Throwable throwable;

    public CommandFailedEvent(int requestId, ConnectionDescription connectionDescription, String commandName, long elapsedTimeNanos, Throwable throwable) {
        super(requestId, connectionDescription, commandName);
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
        this.throwable = throwable;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

