/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.event;

import dev.brighten.antivpn.shaded.com.mongodb.assertions.Assertions;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ConnectionDescription;
import dev.brighten.antivpn.shaded.com.mongodb.event.CommandEvent;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import java.util.concurrent.TimeUnit;

public final class CommandSucceededEvent
extends CommandEvent {
    private final BsonDocument response;
    private final long elapsedTimeNanos;

    public CommandSucceededEvent(int requestId, ConnectionDescription connectionDescription, String commandName, BsonDocument response, long elapsedTimeNanos) {
        super(requestId, connectionDescription, commandName);
        this.response = response;
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

