/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.internal.connection;

import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.Compressor;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.MessageSettings;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.OpCode;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.RequestMessage;
import dev.brighten.antivpn.shaded.com.mongodb.session.SessionContext;
import dev.brighten.antivpn.shaded.org.bson.ByteBuf;
import dev.brighten.antivpn.shaded.org.bson.io.BsonOutput;
import java.util.List;

class CompressedMessage
extends RequestMessage {
    private final OpCode wrappedOpcode;
    private final List<ByteBuf> wrappedMessageBuffers;
    private final Compressor compressor;

    CompressedMessage(OpCode wrappedOpcode, List<ByteBuf> wrappedMessageBuffers, Compressor compressor, MessageSettings settings) {
        super(OpCode.OP_COMPRESSED, CompressedMessage.getWrappedMessageRequestId(wrappedMessageBuffers), settings);
        this.wrappedOpcode = wrappedOpcode;
        this.wrappedMessageBuffers = wrappedMessageBuffers;
        this.compressor = compressor;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, SessionContext sessionContext) {
        bsonOutput.writeInt32(this.wrappedOpcode.getValue());
        bsonOutput.writeInt32(CompressedMessage.getWrappedMessageSize(this.wrappedMessageBuffers) - 16);
        bsonOutput.writeByte(this.compressor.getId());
        CompressedMessage.getFirstWrappedMessageBuffer(this.wrappedMessageBuffers).position(CompressedMessage.getFirstWrappedMessageBuffer(this.wrappedMessageBuffers).position() + 16);
        this.compressor.compress(this.wrappedMessageBuffers, bsonOutput);
        return new RequestMessage.EncodingMetadata(0);
    }

    private static int getWrappedMessageSize(List<ByteBuf> wrappedMessageBuffers) {
        ByteBuf first = CompressedMessage.getFirstWrappedMessageBuffer(wrappedMessageBuffers);
        return first.getInt(0);
    }

    private static int getWrappedMessageRequestId(List<ByteBuf> wrappedMessageBuffers) {
        ByteBuf first = CompressedMessage.getFirstWrappedMessageBuffer(wrappedMessageBuffers);
        return first.getInt(4);
    }

    private static ByteBuf getFirstWrappedMessageBuffer(List<ByteBuf> wrappedMessageBuffers) {
        return wrappedMessageBuffers.get(0);
    }
}

