/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.internal.connection;

import dev.brighten.antivpn.shaded.com.mongodb.MongoNamespace;
import dev.brighten.antivpn.shaded.com.mongodb.WriteConcernResult;
import dev.brighten.antivpn.shaded.com.mongodb.async.SingleResultCallback;
import dev.brighten.antivpn.shaded.com.mongodb.bulk.DeleteRequest;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ByteBufferBsonOutput;
import dev.brighten.antivpn.shaded.com.mongodb.diagnostics.logging.Logger;
import dev.brighten.antivpn.shaded.com.mongodb.diagnostics.logging.Loggers;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.ByteBufBsonDocument;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.DeleteMessage;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.InternalConnection;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.MessageSettings;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.RequestMessage;
import dev.brighten.antivpn.shaded.com.mongodb.internal.connection.WriteProtocol;
import dev.brighten.antivpn.shaded.org.bson.BsonArray;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonInt32;
import java.util.Collections;

class DeleteProtocol
extends WriteProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.delete");
    private final DeleteRequest deleteRequest;

    DeleteProtocol(MongoNamespace namespace, boolean ordered, DeleteRequest deleteRequest) {
        super(namespace, ordered);
        this.deleteRequest = deleteRequest;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Deleting documents from namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        WriteConcernResult writeConcernResult = super.execute(connection);
        LOGGER.debug("Delete completed");
        return writeConcernResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously deleting documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                @Override
                public void onResult(WriteConcernResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous delete completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected BsonDocument getAsWriteCommand(ByteBufferBsonOutput bsonOutput, int firstDocumentPosition) {
        BsonDocument deleteDocument = new BsonDocument("q", ByteBufBsonDocument.createOne(bsonOutput, firstDocumentPosition)).append("limit", this.deleteRequest.isMulti() ? new BsonInt32(0) : new BsonInt32(1));
        return this.getBaseCommandDocument("delete").append("deletes", new BsonArray(Collections.singletonList(deleteDocument)));
    }

    @Override
    protected RequestMessage createRequestMessage(MessageSettings settings) {
        return new DeleteMessage(this.getNamespace().getFullName(), this.deleteRequest, settings);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

