/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.internal.connection;

import dev.brighten.antivpn.shaded.com.mongodb.ReadConcernLevel;
import dev.brighten.antivpn.shaded.com.mongodb.assertions.Assertions;
import dev.brighten.antivpn.shaded.com.mongodb.session.SessionContext;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonString;

public final class ReadConcernHelper {
    public static BsonDocument getReadConcernDocument(SessionContext sessionContext) {
        Assertions.notNull("sessionContext", sessionContext);
        BsonDocument readConcernDocument = new BsonDocument();
        ReadConcernLevel level = sessionContext.getReadConcern().getLevel();
        if (level != null) {
            readConcernDocument.append("level", new BsonString(level.getValue()));
        }
        if (ReadConcernHelper.shouldAddAfterClusterTime(sessionContext)) {
            readConcernDocument.append("afterClusterTime", sessionContext.getOperationTime());
        }
        return readConcernDocument;
    }

    private static boolean shouldAddAfterClusterTime(SessionContext sessionContext) {
        return sessionContext.isCausallyConsistent() && sessionContext.getOperationTime() != null;
    }

    private ReadConcernHelper() {
    }
}

