/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.internal.operation;

import dev.brighten.antivpn.shaded.com.mongodb.client.model.IndexModel;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonNumber;
import dev.brighten.antivpn.shaded.org.bson.BsonString;
import dev.brighten.antivpn.shaded.org.bson.BsonValue;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecRegistry;
import java.util.ArrayList;
import java.util.List;

public final class IndexHelper {
    public static List<String> getIndexNames(List<IndexModel> indexes, CodecRegistry codecRegistry) {
        ArrayList<String> indexNames = new ArrayList<String>(indexes.size());
        for (IndexModel index : indexes) {
            String name = index.getOptions().getName();
            if (name != null) {
                indexNames.add(name);
                continue;
            }
            indexNames.add(IndexHelper.generateIndexName(index.getKeys().toBsonDocument(BsonDocument.class, codecRegistry)));
        }
        return indexNames;
    }

    public static String generateIndexName(BsonDocument index) {
        StringBuilder indexName = new StringBuilder();
        for (String keyNames : index.keySet()) {
            if (indexName.length() != 0) {
                indexName.append('_');
            }
            indexName.append(keyNames).append('_');
            BsonValue ascOrDescValue = index.get(keyNames);
            if (ascOrDescValue instanceof BsonNumber) {
                indexName.append(((BsonNumber)ascOrDescValue).intValue());
                continue;
            }
            if (!(ascOrDescValue instanceof BsonString)) continue;
            indexName.append(((BsonString)ascOrDescValue).getValue().replace(' ', '_'));
        }
        return indexName.toString();
    }

    private IndexHelper() {
    }
}

