/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.management;

import dev.brighten.antivpn.shaded.com.mongodb.ServerAddress;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ConnectionPoolSettings;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionAddedEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionCheckedInEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionCheckedOutEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionPoolListenerAdapter;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionPoolOpenedEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionPoolWaitQueueEnteredEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionPoolWaitQueueExitedEvent;
import dev.brighten.antivpn.shaded.com.mongodb.event.ConnectionRemovedEvent;
import dev.brighten.antivpn.shaded.com.mongodb.management.ConnectionPoolStatisticsMBean;
import java.util.concurrent.atomic.AtomicInteger;

final class ConnectionPoolStatistics
extends ConnectionPoolListenerAdapter
implements ConnectionPoolStatisticsMBean {
    private final ServerAddress serverAddress;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger checkedOutCount = new AtomicInteger();
    private final AtomicInteger waitQueueSize = new AtomicInteger();

    ConnectionPoolStatistics(ConnectionPoolOpenedEvent event) {
        this.serverAddress = event.getServerId().getAddress();
        this.settings = event.getSettings();
    }

    @Override
    public String getHost() {
        return this.serverAddress.getHost();
    }

    @Override
    public int getPort() {
        return this.serverAddress.getPort();
    }

    @Override
    public int getMinSize() {
        return this.settings.getMinSize();
    }

    @Override
    public int getMaxSize() {
        return this.settings.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getCheckedOutCount() {
        return this.checkedOutCount.get();
    }

    @Override
    public int getWaitQueueSize() {
        return this.waitQueueSize.get();
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        this.checkedOutCount.incrementAndGet();
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        this.checkedOutCount.decrementAndGet();
    }

    @Override
    public void connectionAdded(ConnectionAddedEvent event) {
        this.size.incrementAndGet();
    }

    @Override
    public void connectionRemoved(ConnectionRemovedEvent event) {
        this.size.decrementAndGet();
    }

    @Override
    public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
        this.waitQueueSize.incrementAndGet();
    }

    @Override
    public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
        this.waitQueueSize.decrementAndGet();
    }
}

