/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.operation;

import dev.brighten.antivpn.shaded.com.mongodb.MongoNamespace;
import dev.brighten.antivpn.shaded.com.mongodb.ServerAddress;
import dev.brighten.antivpn.shaded.com.mongodb.assertions.Assertions;
import dev.brighten.antivpn.shaded.com.mongodb.async.AsyncBatchCursor;
import dev.brighten.antivpn.shaded.com.mongodb.async.SingleResultCallback;
import dev.brighten.antivpn.shaded.com.mongodb.binding.AsyncConnectionSource;
import dev.brighten.antivpn.shaded.com.mongodb.binding.AsyncReadBinding;
import dev.brighten.antivpn.shaded.com.mongodb.binding.ConnectionSource;
import dev.brighten.antivpn.shaded.com.mongodb.binding.ReadBinding;
import dev.brighten.antivpn.shaded.com.mongodb.connection.AsyncConnection;
import dev.brighten.antivpn.shaded.com.mongodb.connection.Connection;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ConnectionDescription;
import dev.brighten.antivpn.shaded.com.mongodb.connection.QueryResult;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ServerDescription;
import dev.brighten.antivpn.shaded.com.mongodb.internal.async.ErrorHandlingResultCallback;
import dev.brighten.antivpn.shaded.com.mongodb.operation.AsyncQueryBatchCursor;
import dev.brighten.antivpn.shaded.com.mongodb.operation.AsyncReadOperation;
import dev.brighten.antivpn.shaded.com.mongodb.operation.BatchCursor;
import dev.brighten.antivpn.shaded.com.mongodb.operation.CommandOperationHelper;
import dev.brighten.antivpn.shaded.com.mongodb.operation.CommandResultDocumentCodec;
import dev.brighten.antivpn.shaded.com.mongodb.operation.OperationHelper;
import dev.brighten.antivpn.shaded.com.mongodb.operation.OperationReadConcernHelper;
import dev.brighten.antivpn.shaded.com.mongodb.operation.QueryBatchCursor;
import dev.brighten.antivpn.shaded.com.mongodb.operation.ReadOperation;
import dev.brighten.antivpn.shaded.com.mongodb.session.SessionContext;
import dev.brighten.antivpn.shaded.org.bson.BsonArray;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonInt32;
import dev.brighten.antivpn.shaded.org.bson.BsonString;
import dev.brighten.antivpn.shaded.org.bson.BsonValue;
import dev.brighten.antivpn.shaded.org.bson.codecs.Decoder;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ParallelCollectionScanOperation<T>
implements AsyncReadOperation<List<AsyncBatchCursor<T>>>,
ReadOperation<List<BatchCursor<T>>> {
    private final MongoNamespace namespace;
    private final int numCursors;
    private boolean retryReads;
    private int batchSize = 0;
    private final Decoder<T> decoder;

    public ParallelCollectionScanOperation(MongoNamespace namespace, int numCursors, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        Assertions.isTrue("numCursors >= 1", numCursors >= 1);
        this.numCursors = numCursors;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public int getNumCursors() {
        return this.numCursors;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ParallelCollectionScanOperation<T> batchSize(int batchSize) {
        Assertions.isTrue("batchSize >= 0", batchSize >= 0);
        this.batchSize = batchSize;
        return this;
    }

    public ParallelCollectionScanOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Override
    public List<BatchCursor<T>> execute(ReadBinding binding) {
        return CommandOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, "firstBatch"), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<List<AsyncBatchCursor<T>>> callback) {
        CommandOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, "firstBatch"), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, List<BatchCursor<T>>> transformer() {
        return new CommandOperationHelper.CommandReadTransformer<BsonDocument, List<BatchCursor<T>>>(){

            @Override
            public List<BatchCursor<T>> apply(BsonDocument result, ConnectionSource source, Connection connection) {
                ArrayList cursors = new ArrayList();
                for (BsonValue cursorValue : ParallelCollectionScanOperation.this.getCursorDocuments(result)) {
                    cursors.add(new QueryBatchCursor(ParallelCollectionScanOperation.this.createQueryResult(ParallelCollectionScanOperation.this.getCursorDocument(cursorValue.asDocument()), source.getServerDescription().getAddress()), 0, ParallelCollectionScanOperation.this.getBatchSize(), ParallelCollectionScanOperation.this.decoder, source));
                }
                return cursors;
            }
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, List<AsyncBatchCursor<T>>> asyncTransformer() {
        return new CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, List<AsyncBatchCursor<T>>>(){

            @Override
            public List<AsyncBatchCursor<T>> apply(BsonDocument result, AsyncConnectionSource source, AsyncConnection connection) {
                ArrayList cursors = new ArrayList();
                for (BsonValue cursorValue : ParallelCollectionScanOperation.this.getCursorDocuments(result)) {
                    cursors.add(new AsyncQueryBatchCursor(ParallelCollectionScanOperation.this.createQueryResult(ParallelCollectionScanOperation.this.getCursorDocument(cursorValue.asDocument()), source.getServerDescription().getAddress()), 0, ParallelCollectionScanOperation.this.getBatchSize(), 0L, ParallelCollectionScanOperation.this.decoder, source, connection, result));
                }
                return cursors;
            }
        };
    }

    private BsonArray getCursorDocuments(BsonDocument result) {
        return result.getArray("cursors");
    }

    private BsonDocument getCursorDocument(BsonDocument cursorDocument) {
        return cursorDocument.getDocument("cursor");
    }

    private QueryResult<T> createQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(final SessionContext sessionContext) {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateReadConcern(connectionDescription, sessionContext.getReadConcern());
                return ParallelCollectionScanOperation.this.getCommand(sessionContext);
            }
        };
    }

    private BsonDocument getCommand(SessionContext sessionContext) {
        BsonDocument document = new BsonDocument("parallelCollectionScan", new BsonString(this.namespace.getCollectionName())).append("numCursors", new BsonInt32(this.getNumCursors()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, document);
        return document;
    }
}

