/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mongodb.operation;

import dev.brighten.antivpn.shaded.com.mongodb.MongoCommandException;
import dev.brighten.antivpn.shaded.com.mongodb.MongoCredential;
import dev.brighten.antivpn.shaded.com.mongodb.MongoInternalException;
import dev.brighten.antivpn.shaded.com.mongodb.async.SingleResultCallback;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ConnectionDescription;
import dev.brighten.antivpn.shaded.com.mongodb.connection.ServerVersion;
import dev.brighten.antivpn.shaded.com.mongodb.internal.authentication.NativeAuthenticationHelper;
import dev.brighten.antivpn.shaded.com.mongodb.internal.operation.ServerVersionHelper;
import dev.brighten.antivpn.shaded.com.mongodb.internal.operation.WriteConcernHelper;
import dev.brighten.antivpn.shaded.com.mongodb.lang.NonNull;
import dev.brighten.antivpn.shaded.org.bson.BsonArray;
import dev.brighten.antivpn.shaded.org.bson.BsonBoolean;
import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonString;
import java.util.Collections;

final class UserOperationHelper {
    private static final ServerVersion FOUR_ZERO = new ServerVersion(4, 0);

    static BsonDocument asCommandDocument(MongoCredential credential, ConnectionDescription connectionDescription, boolean readOnly, String commandName) {
        boolean serverDigestPassword = ServerVersionHelper.serverIsAtLeastVersionFourDotZero(connectionDescription);
        BsonDocument document = new BsonDocument();
        document.put(commandName, new BsonString(UserOperationHelper.getUserNameNonNull(credential)));
        if (serverDigestPassword) {
            document.put("pwd", new BsonString(new String(UserOperationHelper.getPasswordNonNull(credential))));
        } else {
            document.put("pwd", new BsonString(NativeAuthenticationHelper.createAuthenticationHash(UserOperationHelper.getUserNameNonNull(credential), UserOperationHelper.getPasswordNonNull(credential))));
        }
        document.put("digestPassword", BsonBoolean.valueOf(serverDigestPassword));
        document.put("roles", new BsonArray(Collections.singletonList(new BsonString(UserOperationHelper.getRoleName(credential, readOnly)))));
        return document;
    }

    private static String getRoleName(MongoCredential credential, boolean readOnly) {
        return credential.getSource().equals("admin") ? (readOnly ? "readAnyDatabase" : "root") : (readOnly ? "read" : "dbOwner");
    }

    static void translateUserCommandException(MongoCommandException e) {
        if (e.getErrorCode() == 100 && WriteConcernHelper.hasWriteConcernError(e.getResponse())) {
            throw WriteConcernHelper.createWriteConcernException(e.getResponse(), e.getServerAddress());
        }
        throw e;
    }

    static SingleResultCallback<Void> userCommandCallback(final SingleResultCallback<Void> wrappedCallback) {
        return new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    if (t instanceof MongoCommandException && WriteConcernHelper.hasWriteConcernError(((MongoCommandException)t).getResponse())) {
                        wrappedCallback.onResult(null, WriteConcernHelper.createWriteConcernException(((MongoCommandException)t).getResponse(), ((MongoCommandException)t).getServerAddress()));
                    } else {
                        wrappedCallback.onResult(null, t);
                    }
                } else {
                    wrappedCallback.onResult(null, null);
                }
            }
        };
    }

    @NonNull
    private static String getUserNameNonNull(MongoCredential credential) {
        String userName = credential.getUserName();
        if (userName == null) {
            throw new MongoInternalException("User name can not be null");
        }
        return userName;
    }

    @NonNull
    private static char[] getPasswordNonNull(MongoCredential credential) {
        char[] password = credential.getPassword();
        if (password == null) {
            throw new MongoInternalException("Password can not be null");
        }
        return password;
    }

    private UserOperationHelper() {
    }
}

