/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mysql.cj;

import dev.brighten.antivpn.shaded.com.mysql.cj.DataStoreMetadata;
import dev.brighten.antivpn.shaded.com.mysql.cj.DataStoreMetadataImpl;
import dev.brighten.antivpn.shaded.com.mysql.cj.MessageBuilder;
import dev.brighten.antivpn.shaded.com.mysql.cj.Session;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.HostInfo;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.PropertyKey;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.PropertySet;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.RuntimeProperty;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.CJOperationNotSupportedException;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.ExceptionFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.ExceptionInterceptor;
import dev.brighten.antivpn.shaded.com.mysql.cj.log.Log;
import dev.brighten.antivpn.shaded.com.mysql.cj.log.LogFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.log.NullLogger;
import dev.brighten.antivpn.shaded.com.mysql.cj.log.ProfilerEventHandler;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.Message;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.Protocol;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.ServerSession;
import dev.brighten.antivpn.shaded.com.mysql.cj.telemetry.TelemetryHandler;
import dev.brighten.antivpn.shaded.com.mysql.cj.util.Util;
import java.net.SocketAddress;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class CoreSession
implements Session {
    protected PropertySet propertySet;
    protected ExceptionInterceptor exceptionInterceptor;
    protected transient Log log;
    protected static final Log NULL_LOGGER = new NullLogger("MySQL");
    protected transient Protocol<? extends Message> protocol;
    protected MessageBuilder<? extends Message> messageBuilder;
    protected long connectionCreationTimeMillis = 0L;
    protected HostInfo hostInfo = null;
    protected RuntimeProperty<Boolean> gatherPerfMetrics;
    protected RuntimeProperty<String> characterEncoding;
    protected RuntimeProperty<Boolean> disconnectOnExpiredPasswords;
    protected RuntimeProperty<Boolean> cacheServerConfiguration;
    protected RuntimeProperty<Boolean> autoReconnect;
    protected RuntimeProperty<Boolean> autoReconnectForPools;
    protected RuntimeProperty<Boolean> maintainTimeStats;
    protected int sessionMaxRows = -1;
    private ProfilerEventHandler eventSink;
    private final Lock lock = new ReentrantLock();
    private TelemetryHandler telemetryHandler = null;

    public CoreSession(HostInfo hostInfo, PropertySet propSet) {
        this.connectionCreationTimeMillis = System.currentTimeMillis();
        this.hostInfo = hostInfo;
        this.propertySet = propSet;
        this.gatherPerfMetrics = this.getPropertySet().getBooleanProperty(PropertyKey.gatherPerfMetrics);
        this.characterEncoding = this.getPropertySet().getStringProperty(PropertyKey.characterEncoding);
        this.disconnectOnExpiredPasswords = this.getPropertySet().getBooleanProperty(PropertyKey.disconnectOnExpiredPasswords);
        this.cacheServerConfiguration = this.getPropertySet().getBooleanProperty(PropertyKey.cacheServerConfiguration);
        this.autoReconnect = this.getPropertySet().getBooleanProperty(PropertyKey.autoReconnect);
        this.autoReconnectForPools = this.getPropertySet().getBooleanProperty(PropertyKey.autoReconnectForPools);
        this.maintainTimeStats = this.getPropertySet().getBooleanProperty(PropertyKey.maintainTimeStats);
        this.log = LogFactory.getLogger(this.getPropertySet().getStringProperty(PropertyKey.logger).getStringValue(), "MySQL");
    }

    @Override
    public Lock getSessionLock() {
        return this.lock;
    }

    @Override
    public void changeUser(String user, String password, String database) {
        this.sessionMaxRows = -1;
        this.protocol.changeUser(user, password, database);
    }

    @Override
    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public void setExceptionInterceptor(ExceptionInterceptor exceptionInterceptor) {
        this.exceptionInterceptor = exceptionInterceptor;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    @Override
    public <M extends Message> MessageBuilder<M> getMessageBuilder() {
        return this.messageBuilder;
    }

    @Override
    public ServerSession getServerSession() {
        return this.protocol.getServerSession();
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        return this.protocol.versionMeetsMinimum(major, minor, subminor);
    }

    @Override
    public long getThreadId() {
        return this.protocol.getServerSession().getCapabilities().getThreadId();
    }

    @Override
    public void quit() {
        if (this.eventSink != null) {
            this.eventSink.destroy();
            this.eventSink = null;
        }
    }

    @Override
    public void forceClose() {
        if (this.eventSink != null) {
            this.eventSink.destroy();
            this.eventSink = null;
        }
    }

    @Override
    public boolean isSetNeededForAutoCommitMode(boolean autoCommitFlag) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public ProfilerEventHandler getProfilerEventHandler() {
        if (this.eventSink == null) {
            this.getSessionLock().lock();
            try {
                if (this.eventSink == null) {
                    this.eventSink = Util.getInstance(ProfilerEventHandler.class, this.propertySet.getStringProperty(PropertyKey.profilerEventHandler).getStringValue(), null, null, this.exceptionInterceptor);
                    this.eventSink.init(this.log);
                }
            }
            finally {
                this.getSessionLock().unlock();
            }
        }
        return this.eventSink;
    }

    @Override
    public String getQueryComment() {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public void setQueryComment(String comment) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public void setTelemetryHandler(TelemetryHandler telemetryHandler) {
        this.telemetryHandler = telemetryHandler;
    }

    @Override
    public TelemetryHandler getTelemetryHandler() {
        return this.telemetryHandler;
    }

    @Override
    public boolean isSSLEstablished() {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public void addListener(Session.SessionEventListener l) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public void removeListener(Session.SessionEventListener l) {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public String getIdentifierQuoteString() {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, "Not supported");
    }

    @Override
    public DataStoreMetadata getDataStoreMetadata() {
        return new DataStoreMetadataImpl(this);
    }

    @Override
    public String getQueryTimingUnits() {
        return this.protocol.getQueryTimingUnits();
    }
}

