/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mysql.cj;

import dev.brighten.antivpn.shaded.com.mysql.cj.CacheAdapter;
import dev.brighten.antivpn.shaded.com.mysql.cj.CacheAdapterFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.QueryInfo;
import dev.brighten.antivpn.shaded.com.mysql.cj.util.LRUCache;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class PerConnectionLRUFactory
implements CacheAdapterFactory<String, QueryInfo> {
    @Override
    public CacheAdapter<String, QueryInfo> getInstance(Lock lock, String url, int cacheMaxSize, int maxKeySize) {
        return new PerConnectionLRU(lock, cacheMaxSize, maxKeySize);
    }

    class PerConnectionLRU
    implements CacheAdapter<String, QueryInfo> {
        private final int cacheSqlLimit;
        private final LRUCache<String, QueryInfo> cache;
        private final Lock lock;

        protected PerConnectionLRU(Lock lock, int cacheMaxSize, int maxKeySize) {
            int cacheSize = cacheMaxSize;
            this.cacheSqlLimit = maxKeySize;
            this.cache = new LRUCache(cacheSize);
            this.lock = lock;
        }

        @Override
        public QueryInfo get(String key) {
            if (key == null || key.length() > this.cacheSqlLimit) {
                return null;
            }
            this.lock.lock();
            try {
                QueryInfo queryInfo = (QueryInfo)this.cache.get(key);
                return queryInfo;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void put(String key, QueryInfo value) {
            if (key == null || key.length() > this.cacheSqlLimit) {
                return;
            }
            this.lock.lock();
            try {
                this.cache.put(key, value);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void invalidate(String key) {
            this.lock.lock();
            try {
                this.cache.remove(key);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateAll(Set<String> keys) {
            this.lock.lock();
            try {
                for (String key : keys) {
                    this.cache.remove(key);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void invalidateAll() {
            this.lock.lock();
            try {
                this.cache.clear();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

