/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mysql.cj.jdbc;

import dev.brighten.antivpn.shaded.com.mysql.cj.CacheAdapter;
import dev.brighten.antivpn.shaded.com.mysql.cj.CacheAdapterFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.LicenseConfiguration;
import dev.brighten.antivpn.shaded.com.mysql.cj.Messages;
import dev.brighten.antivpn.shaded.com.mysql.cj.NativeSession;
import dev.brighten.antivpn.shaded.com.mysql.cj.NoSubInterceptorWrapper;
import dev.brighten.antivpn.shaded.com.mysql.cj.PreparedQuery;
import dev.brighten.antivpn.shaded.com.mysql.cj.QueryInfo;
import dev.brighten.antivpn.shaded.com.mysql.cj.ServerVersion;
import dev.brighten.antivpn.shaded.com.mysql.cj.Session;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.HostInfo;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.PropertyDefinitions;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.PropertyKey;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.RuntimeProperty;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.CJCommunicationsException;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.CJException;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.ExceptionFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.ExceptionInterceptor;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.ExceptionInterceptorChain;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.PasswordExpiredException;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.UnableToConnectException;
import dev.brighten.antivpn.shaded.com.mysql.cj.interceptors.QueryInterceptor;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.AbandonedConnectionCleanupThread;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.Blob;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.CallableStatement;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ClientInfoProvider;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ClientPreparedStatement;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.Clob;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.CloseOption;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.DatabaseMetaData;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.EscapeProcessor;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.EscapeProcessorResult;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.IterateBlock;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.JdbcConnection;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.JdbcPreparedStatement;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.JdbcPropertySet;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.JdbcPropertySetImpl;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.JdbcStatement;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.MysqlSQLXML;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.MysqlSavepoint;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.NClob;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ServerPreparedStatement;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.StatementImpl;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.exceptions.SQLError;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.MultiHostConnectionProxy;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.MultiHostMySQLConnection;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.interceptors.ConnectionLifecycleInterceptor;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.result.CachedResultSetMetaData;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.result.CachedResultSetMetaDataImpl;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.result.ResultSetFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.result.ResultSetInternalMethods;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.result.UpdatableResultSet;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.ServerSessionStateController;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.SocksProxySocketFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.a.NativeProtocol;
import dev.brighten.antivpn.shaded.com.mysql.cj.telemetry.TelemetryAttribute;
import dev.brighten.antivpn.shaded.com.mysql.cj.telemetry.TelemetryScope;
import dev.brighten.antivpn.shaded.com.mysql.cj.telemetry.TelemetrySpan;
import dev.brighten.antivpn.shaded.com.mysql.cj.telemetry.TelemetrySpanName;
import dev.brighten.antivpn.shaded.com.mysql.cj.util.LRUCache;
import dev.brighten.antivpn.shaded.com.mysql.cj.util.StringUtils;
import dev.brighten.antivpn.shaded.com.mysql.cj.util.Util;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.Array;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class ConnectionImpl
implements JdbcConnection,
Session.SessionEventListener,
Serializable {
    private static final long serialVersionUID = 4009476458425101761L;
    private static final SQLPermission SET_NETWORK_TIMEOUT_PERM = new SQLPermission("setNetworkTimeout");
    private static final SQLPermission ABORT_PERM = new SQLPermission("abort");
    private JdbcConnection parentProxy = null;
    private JdbcConnection topProxy = null;
    private MultiHostConnectionProxy realProxy = null;
    private final Lock lock = new ReentrantLock();
    private static Map<String, Integer> mapTransIsolationNameToValue = null;
    protected static Map<?, ?> roundRobinStatsMap;
    private List<ConnectionLifecycleInterceptor> connectionLifecycleInterceptors;
    private static final int DEFAULT_RESULT_SET_TYPE = 1003;
    private static final int DEFAULT_RESULT_SET_CONCURRENCY = 1007;
    private CacheAdapter<String, QueryInfo> queryInfoCache;
    private String database = null;
    private java.sql.DatabaseMetaData dbmd = null;
    private NativeSession session = null;
    private boolean isInGlobalTx = false;
    private int isolationLevel = 2;
    private final CopyOnWriteArrayList<JdbcStatement> openStatements = new CopyOnWriteArrayList();
    private LRUCache<CompoundCacheKey, CallableStatement.CallableStatementParamInfo> parsedCallableStatementCache;
    private final Lock parsedCallableStatementCacheLock = new ReentrantLock();
    private String password = null;
    protected Properties props = null;
    private boolean readOnly = false;
    protected LRUCache<String, CachedResultSetMetaData> resultSetMetadataCache;
    protected final Lock resultSetMetadataCacheLock = new ReentrantLock();
    private Map<String, Class<?>> typeMap;
    private String user = null;
    private LRUCache<String, Boolean> serverSideStatementCheckCache;
    private final Lock serverSideStatementCheckCacheLock = new ReentrantLock();
    private LRUCache<CompoundCacheKey, ServerPreparedStatement> serverSideStatementCache;
    private HostInfo origHostInfo;
    private String origHostToConnectTo;
    private int origPortToConnectTo;
    private List<QueryInterceptor> queryInterceptors;
    protected JdbcPropertySet propertySet;
    private RuntimeProperty<Boolean> autoReconnectForPools;
    private RuntimeProperty<Boolean> cachePrepStmts;
    private RuntimeProperty<Boolean> autoReconnect;
    private RuntimeProperty<Boolean> useUsageAdvisor;
    private RuntimeProperty<Boolean> reconnectAtTxEnd;
    private RuntimeProperty<Boolean> emulateUnsupportedPstmts;
    private RuntimeProperty<Boolean> ignoreNonTxTables;
    private RuntimeProperty<Boolean> pedantic;
    private RuntimeProperty<Integer> prepStmtCacheSqlLimit;
    private RuntimeProperty<Boolean> useLocalSessionState;
    private RuntimeProperty<Boolean> useServerPrepStmts;
    private RuntimeProperty<Boolean> processEscapeCodesForPrepStmts;
    private RuntimeProperty<Boolean> useLocalTransactionState;
    private RuntimeProperty<Boolean> disconnectOnExpiredPasswords;
    private RuntimeProperty<Boolean> readOnlyPropagatesToServer;
    protected ResultSetFactory nullStatementResultSetFactory;
    TelemetrySpan connectionSpan = null;
    private int autoIncrementIncrement = 0;
    private ExceptionInterceptor exceptionInterceptor;
    private ClientInfoProvider infoProvider;

    @Override
    public String getHost() {
        return this.session.getHostInfo().getHost();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public boolean isProxySet() {
        return this.topProxy != null;
    }

    @Override
    public void setProxy(JdbcConnection proxy) {
        if (this.parentProxy == null) {
            this.parentProxy = proxy;
        }
        this.topProxy = proxy;
        this.realProxy = this.topProxy instanceof MultiHostMySQLConnection ? ((MultiHostMySQLConnection)proxy).getThisAsProxy() : null;
    }

    private JdbcConnection getProxy() {
        return this.topProxy != null ? this.topProxy : this;
    }

    @Override
    public JdbcConnection getMultiHostSafeProxy() {
        return this.getProxy();
    }

    @Override
    public JdbcConnection getMultiHostParentProxy() {
        return this.parentProxy;
    }

    @Override
    public JdbcConnection getActiveMySQLConnection() {
        return this;
    }

    @Override
    public Lock getConnectionLock() {
        return this.realProxy != null ? this.realProxy.getLock() : this.getProxy().getLock();
    }

    public static JdbcConnection getInstance(HostInfo hostInfo) throws SQLException {
        return new ConnectionImpl(hostInfo);
    }

    protected ConnectionImpl() {
    }

    public ConnectionImpl(HostInfo hostInfo) throws SQLException {
        try {
            this.origHostInfo = hostInfo;
            this.origHostToConnectTo = hostInfo.getHost();
            this.origPortToConnectTo = hostInfo.getPort();
            this.database = hostInfo.getDatabase();
            this.user = hostInfo.getUser();
            this.password = hostInfo.getPassword();
            this.props = hostInfo.exposeAsProperties();
            this.propertySet = new JdbcPropertySetImpl();
            this.propertySet.initializeProperties(this.props);
            this.nullStatementResultSetFactory = new ResultSetFactory(this, null);
            this.session = new NativeSession(hostInfo, this.propertySet);
            this.session.addListener(this);
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
        }
        this.connectionSpan = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.CONNECTION_CREATE, new Object[0]);
        this.session.getTelemetryHandler().addLinkTarget(this.connectionSpan);
        try (TelemetryScope scope = this.connectionSpan.makeCurrent();){
            this.connectionSpan.setAttribute(TelemetryAttribute.DB_CONNECTION_STRING, this.getURL());
            this.connectionSpan.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
            this.connectionSpan.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
            this.connectionSpan.setAttribute(TelemetryAttribute.SERVER_ADDRESS, this.origHostToConnectTo);
            this.connectionSpan.setAttribute(TelemetryAttribute.SERVER_PORT, this.origPortToConnectTo);
            this.connectionSpan.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
            this.connectionSpan.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
            try {
                String exceptionInterceptorClasses = this.propertySet.getStringProperty(PropertyKey.exceptionInterceptors).getStringValue();
                if (exceptionInterceptorClasses != null && !"".equals(exceptionInterceptorClasses)) {
                    this.exceptionInterceptor = new ExceptionInterceptorChain(exceptionInterceptorClasses, this.props, this.session.getLog());
                }
                this.autoReconnectForPools = this.propertySet.getBooleanProperty(PropertyKey.autoReconnectForPools);
                this.cachePrepStmts = this.propertySet.getBooleanProperty(PropertyKey.cachePrepStmts);
                this.autoReconnect = this.propertySet.getBooleanProperty(PropertyKey.autoReconnect);
                this.useUsageAdvisor = this.propertySet.getBooleanProperty(PropertyKey.useUsageAdvisor);
                this.reconnectAtTxEnd = this.propertySet.getBooleanProperty(PropertyKey.reconnectAtTxEnd);
                this.emulateUnsupportedPstmts = this.propertySet.getBooleanProperty(PropertyKey.emulateUnsupportedPstmts);
                this.ignoreNonTxTables = this.propertySet.getBooleanProperty(PropertyKey.ignoreNonTxTables);
                this.pedantic = this.propertySet.getBooleanProperty(PropertyKey.pedantic);
                this.prepStmtCacheSqlLimit = this.propertySet.getIntegerProperty(PropertyKey.prepStmtCacheSqlLimit);
                this.useLocalSessionState = this.propertySet.getBooleanProperty(PropertyKey.useLocalSessionState);
                this.useServerPrepStmts = this.propertySet.getBooleanProperty(PropertyKey.useServerPrepStmts);
                this.processEscapeCodesForPrepStmts = this.propertySet.getBooleanProperty(PropertyKey.processEscapeCodesForPrepStmts);
                this.useLocalTransactionState = this.propertySet.getBooleanProperty(PropertyKey.useLocalTransactionState);
                this.disconnectOnExpiredPasswords = this.propertySet.getBooleanProperty(PropertyKey.disconnectOnExpiredPasswords);
                this.readOnlyPropagatesToServer = this.propertySet.getBooleanProperty(PropertyKey.readOnlyPropagatesToServer);
                if (this.cachePrepStmts.getValue().booleanValue()) {
                    this.createPreparedStatementCaches();
                }
                if (this.propertySet.getBooleanProperty(PropertyKey.cacheCallableStmts).getValue().booleanValue()) {
                    this.parsedCallableStatementCache = new LRUCache(this.propertySet.getIntegerProperty(PropertyKey.callableStmtCacheSize).getValue());
                }
                if (this.propertySet.getBooleanProperty(PropertyKey.allowMultiQueries).getValue().booleanValue()) {
                    this.propertySet.getProperty(PropertyKey.cacheResultSetMetadata).setValue(false);
                }
                if (this.propertySet.getBooleanProperty(PropertyKey.cacheResultSetMetadata).getValue().booleanValue()) {
                    this.resultSetMetadataCache = new LRUCache(this.propertySet.getIntegerProperty(PropertyKey.metadataCacheSize).getValue());
                }
                if (this.propertySet.getStringProperty(PropertyKey.socksProxyHost).getStringValue() != null) {
                    this.propertySet.getProperty(PropertyKey.socketFactory).setValue(SocksProxySocketFactory.class.getName());
                }
                this.dbmd = this.getMetaData(false, false);
                this.initializeSafeQueryInterceptors();
            }
            catch (CJException e) {
                throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
            }
            try {
                this.createNewIO(false);
                this.unSafeQueryInterceptors();
                AbandonedConnectionCleanupThread.trackConnection(this, this.getSession().getNetworkResources());
                SocketAddress socketAddress = this.session.getRemoteSocketAddress();
                if (InetSocketAddress.class.isInstance(socketAddress)) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    this.connectionSpan.setAttribute(TelemetryAttribute.NETWORK_PEER_ADDRESS, inetSocketAddress.getHostName());
                    this.connectionSpan.setAttribute(TelemetryAttribute.NETWORK_PEER_PORT, inetSocketAddress.getPort());
                    this.connectionSpan.setAttribute(TelemetryAttribute.NETWORK_TRANSPORT, "tcp");
                }
                if (this.propertySet.getStringProperty(PropertyKey.socketFactory).getValue().equalsIgnoreCase("dev.brighten.antivpn.shaded.com.mysql.cj.protocol.NamedPipeSocketFactory")) {
                    this.connectionSpan.setAttribute(TelemetryAttribute.NETWORK_TRANSPORT, "pipe");
                } else if (StringUtils.indexOfIgnoreCase(socketAddress.getClass().getName(), "UNIXSocket") >= 0) {
                    this.connectionSpan.setAttribute(TelemetryAttribute.NETWORK_TRANSPORT, "unix");
                }
            }
            catch (SQLException ex) {
                this.cleanup(ex);
                throw ex;
            }
            catch (Exception ex) {
                this.cleanup(ex);
                throw SQLError.createSQLException(this.propertySet.getBooleanProperty(PropertyKey.paranoid).getValue() != false ? Messages.getString("Connection.0") : Messages.getString("Connection.1", new Object[]{this.session.getHostInfo().getHost(), this.session.getHostInfo().getPort()}), "08S01", ex, this.getExceptionInterceptor());
            }
        }
        catch (Throwable t) {
            this.connectionSpan.setError(t);
            throw t;
        }
        finally {
            this.connectionSpan.end();
        }
    }

    @Override
    public JdbcPropertySet getPropertySet() {
        return this.propertySet;
    }

    @Override
    public void unSafeQueryInterceptors() throws SQLException {
        try {
            this.queryInterceptors = this.queryInterceptors.stream().map(NoSubInterceptorWrapper.class::cast).map(NoSubInterceptorWrapper::getUnderlyingInterceptor).collect(Collectors.toCollection(LinkedList::new));
            if (this.session != null) {
                this.session.setQueryInterceptors(this.queryInterceptors);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void initializeSafeQueryInterceptors() throws SQLException {
        try {
            this.queryInterceptors = Util.loadClasses(QueryInterceptor.class, this.propertySet.getStringProperty(PropertyKey.queryInterceptors).getStringValue(), "MysqlIo.BadQueryInterceptor", this.getExceptionInterceptor()).stream().map(o -> new NoSubInterceptorWrapper(o.init(this, this.props, this.session.getLog()))).collect(Collectors.toCollection(LinkedList::new));
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public List<QueryInterceptor> getQueryInterceptorsInstances() {
        return this.queryInterceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canHandleAsServerPreparedStatement(String sql) throws SQLException {
        boolean allowMultiQueries;
        if (sql == null || sql.length() == 0) {
            return true;
        }
        if (!this.useServerPrepStmts.getValue().booleanValue()) {
            return false;
        }
        boolean bl = allowMultiQueries = this.propertySet.getBooleanProperty(PropertyKey.allowMultiQueries).getValue() != false || this.propertySet.getBooleanProperty(PropertyKey.rewriteBatchedStatements).getValue() != false;
        if (this.cachePrepStmts.getValue().booleanValue()) {
            this.serverSideStatementCheckCacheLock.lock();
            try {
                Boolean flag = (Boolean)this.serverSideStatementCheckCache.get(sql);
                if (flag != null) {
                    boolean bl2 = flag;
                    return bl2;
                }
                boolean canHandle = StringUtils.canHandleAsServerPreparedStatementNoCache(sql, this.getServerVersion(), allowMultiQueries, this.session.getServerSession().isNoBackslashEscapesSet(), this.session.getServerSession().useAnsiQuotedIdentifiers());
                if (sql.length() < this.prepStmtCacheSqlLimit.getValue()) {
                    this.serverSideStatementCheckCache.put(sql, canHandle ? Boolean.TRUE : Boolean.FALSE);
                }
                boolean bl3 = canHandle;
                return bl3;
            }
            finally {
                this.serverSideStatementCheckCacheLock.unlock();
            }
        }
        return StringUtils.canHandleAsServerPreparedStatementNoCache(sql, this.getServerVersion(), allowMultiQueries, this.session.getServerSession().isNoBackslashEscapesSet(), this.session.getServerSession().useAnsiQuotedIdentifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeUser(String userName, String newPassword) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                if (userName == null || userName.equals("")) {
                    userName = "";
                }
                if (newPassword == null) {
                    newPassword = "";
                }
                try {
                    this.session.changeUser(userName, newPassword, this.database);
                }
                catch (CJException ex) {
                    if ("28000".equals(ex.getSQLState())) {
                        this.cleanup(ex);
                    }
                    throw ex;
                }
                this.user = userName;
                this.password = newPassword;
                this.session.getServerSession().getCharsetSettings().configurePostHandshake(true);
                this.session.setSessionVariables();
                this.handleAutoCommitDefaults();
                this.setupServerForTruncationChecks();
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void checkClosed() {
        this.session.checkClosed();
    }

    @Override
    public void throwConnectionClosedException() throws SQLException {
        try {
            SQLException ex = SQLError.createSQLException(Messages.getString("Connection.2"), "08003", this.getExceptionInterceptor());
            if (this.session.getForceClosedReason() != null) {
                ex.initCause(this.session.getForceClosedReason());
            }
            throw ex;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void checkTransactionIsolationLevel() {
        Integer intTI;
        String s = this.session.getServerSession().getServerVariable("transaction_isolation");
        if (s == null) {
            s = this.session.getServerSession().getServerVariable("tx_isolation");
        }
        if (s != null && (intTI = mapTransIsolationNameToValue.get(s)) != null) {
            this.isolationLevel = intTI;
        }
    }

    @Override
    public void abortInternal() throws SQLException {
        try {
            this.session.forceClose();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void cleanup(Throwable whyCleanedUp) {
        try {
            if (this.session != null) {
                if (this.isClosed()) {
                    this.session.forceClose();
                } else {
                    this.doClose(whyCleanedUp, CloseOption.IMPLICIT, CloseOption.PROPAGATE);
                }
            }
        }
        catch (CJException | SQLException exception) {
            // empty catch block
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql) throws SQLException {
        try {
            return this.clientPrepareStatement(sql, 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            PreparedStatement pStmt = this.clientPrepareStatement(sql);
            ((ClientPreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.clientPrepareStatement(sql, resultSetType, resultSetConcurrency, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, boolean processEscapeCodesIfNeeded) throws SQLException {
        try {
            this.checkClosed();
            String nativeSql = processEscapeCodesIfNeeded && this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            ClientPreparedStatement pStmt = null;
            if (this.cachePrepStmts.getValue().booleanValue()) {
                QueryInfo pStmtInfo = this.queryInfoCache.get(nativeSql);
                if (pStmtInfo == null) {
                    pStmt = ClientPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.database);
                    this.queryInfoCache.put(nativeSql, pStmt.getQueryInfo());
                } else {
                    pStmt = ClientPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.database, pStmtInfo);
                }
            } else {
                pStmt = ClientPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.database);
            }
            pStmt.setResultSetType(resultSetType);
            pStmt.setResultSetConcurrency(resultSetConcurrency);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            ClientPreparedStatement pStmt = (ClientPreparedStatement)this.clientPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            ClientPreparedStatement pStmt = (ClientPreparedStatement)this.clientPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.clientPrepareStatement(sql, resultSetType, resultSetConcurrency, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (this.connectionLifecycleInterceptors != null) {
                    for (ConnectionLifecycleInterceptor cli : this.connectionLifecycleInterceptors) {
                        cli.close();
                    }
                }
                this.doClose(null, CloseOption.ROLLBACK, CloseOption.PROPAGATE);
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private void closeAllOpenStatements() throws SQLException {
        SQLException postponedException = null;
        for (JdbcStatement stmt : this.openStatements) {
            try {
                stmt.doClose(CloseOption.IMPLICIT, CloseOption.PROPAGATE, CloseOption.NO_CACHE);
            }
            catch (SQLException sqlEx) {
                postponedException = sqlEx;
            }
        }
        if (postponedException != null) {
            throw postponedException;
        }
    }

    private void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                try {
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock<ConnectionLifecycleInterceptor> iter = new IterateBlock<ConnectionLifecycleInterceptor>(this.connectionLifecycleInterceptors.iterator()){

                            @Override
                            void forEach(ConnectionLifecycleInterceptor each) throws SQLException {
                                if (!each.commit()) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            return;
                        }
                    }
                    if (this.session.getServerSession().isAutoCommit()) {
                        throw SQLError.createSQLException(Messages.getString("Connection.3"), this.getExceptionInterceptor());
                    }
                    if (this.useLocalTransactionState.getValue().booleanValue() && !this.session.getServerSession().inTransactionOnServer()) {
                        return;
                    }
                    TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.ROLLBACK, new Object[0]);
                    try (TelemetryScope scope = span.makeCurrent();){
                        span.setAttribute(TelemetryAttribute.DB_NAME, this.getDatabase());
                        span.setAttribute(TelemetryAttribute.DB_OPERATION, "ROLLBACK");
                        span.setAttribute(TelemetryAttribute.DB_STATEMENT, "ROLLBACK");
                        span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                        span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                        span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                        span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                        this.session.execSQL(null, "COMMIT", -1, null, false, this.nullStatementResultSetFactory, null, false);
                        return;
                    }
                    catch (Throwable t) {
                        span.setError(t);
                        throw t;
                    }
                    finally {
                        span.end();
                    }
                }
                catch (SQLException sqlException) {
                    if (!"08S01".equals(sqlException.getSQLState())) throw sqlException;
                    throw SQLError.createSQLException(Messages.getString("Connection.4"), "08007", this.getExceptionInterceptor());
                }
                finally {
                    this.session.setNeedsPing(this.reconnectAtTxEnd.getValue());
                }
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNewIO(boolean isForReconnect) {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (!this.autoReconnect.getValue().booleanValue()) {
                    this.connectOneTryOnly(isForReconnect);
                    return;
                }
                try {
                    this.connectWithRetries(isForReconnect);
                }
                catch (SQLException ex) {
                    throw ExceptionFactory.createException(UnableToConnectException.class, ex.getMessage(), ex);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithRetries(boolean isForReconnect) throws SQLException {
        double timeout = this.propertySet.getIntegerProperty(PropertyKey.initialTimeout).getValue().intValue();
        boolean connectionGood = false;
        Exception connectionException = null;
        for (int attemptCount = 0; attemptCount < this.propertySet.getIntegerProperty(PropertyKey.maxReconnects).getValue() && !connectionGood; ++attemptCount) {
            try {
                String oldDb;
                boolean oldReadOnly;
                int oldIsolationLevel;
                boolean oldAutoCommit;
                this.session.forceClose();
                JdbcConnection c = this.getProxy();
                this.session.connect(this.origHostInfo, this.user, this.password, this.database, this.getLoginTimeout(), c);
                this.pingInternal(false, 0);
                Lock connectionLock = this.getConnectionLock();
                connectionLock.lock();
                try {
                    oldAutoCommit = this.getAutoCommit();
                    oldIsolationLevel = this.isolationLevel;
                    oldReadOnly = this.isReadOnly(false);
                    oldDb = this.getDatabase();
                    this.session.setQueryInterceptors(this.queryInterceptors);
                }
                finally {
                    connectionLock.unlock();
                }
                this.initializePropsFromServer();
                if (isForReconnect) {
                    this.setAutoCommit(oldAutoCommit);
                    this.setTransactionIsolation(oldIsolationLevel);
                    this.setDatabase(oldDb);
                    this.setReadOnly(oldReadOnly);
                }
                connectionGood = true;
                break;
            }
            catch (UnableToConnectException rejEx) {
                this.close();
                this.session.getProtocol().getSocketConnection().forceClose();
            }
            catch (Exception e) {
                connectionException = e;
                connectionGood = false;
            }
            if (connectionGood) break;
            if (attemptCount <= 0) continue;
            try {
                Thread.sleep((long)timeout * 1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!connectionGood) {
            SQLException chainedEx = SQLError.createSQLException(Messages.getString("Connection.UnableToConnectWithRetries", new Object[]{this.propertySet.getIntegerProperty(PropertyKey.maxReconnects).getValue()}), "08001", connectionException, this.getExceptionInterceptor());
            throw chainedEx;
        }
        if (this.propertySet.getBooleanProperty(PropertyKey.paranoid).getValue().booleanValue() && !this.autoReconnect.getValue().booleanValue()) {
            this.password = null;
            this.user = null;
        }
        if (isForReconnect) {
            Iterator<JdbcStatement> statementIter = this.openStatements.iterator();
            Stack<JdbcStatement> serverPreparedStatements = null;
            while (statementIter.hasNext()) {
                JdbcStatement statementObj = statementIter.next();
                if (!(statementObj instanceof ServerPreparedStatement)) continue;
                if (serverPreparedStatements == null) {
                    serverPreparedStatements = new Stack<JdbcStatement>();
                }
                serverPreparedStatements.add(statementObj);
            }
            if (serverPreparedStatements != null) {
                while (!serverPreparedStatements.isEmpty()) {
                    ((ServerPreparedStatement)serverPreparedStatements.pop()).rePrepare();
                }
            }
        }
    }

    private void connectOneTryOnly(boolean isForReconnect) throws SQLException {
        Exception connectionNotEstablishedBecause = null;
        try {
            JdbcConnection c = this.getProxy();
            this.session.connect(this.origHostInfo, this.user, this.password, this.database, this.getLoginTimeout(), c);
            boolean oldAutoCommit = this.getAutoCommit();
            int oldIsolationLevel = this.isolationLevel;
            boolean oldReadOnly = this.isReadOnly(false);
            String oldDb = this.getDatabase();
            this.session.setQueryInterceptors(this.queryInterceptors);
            this.initializePropsFromServer();
            if (isForReconnect) {
                this.setAutoCommit(oldAutoCommit);
                this.setTransactionIsolation(oldIsolationLevel);
                this.setDatabase(oldDb);
                this.setReadOnly(oldReadOnly);
            }
            return;
        }
        catch (UnableToConnectException rejEx) {
            this.close();
            NativeProtocol protocol = this.session.getProtocol();
            if (protocol != null) {
                protocol.getSocketConnection().forceClose();
            }
            throw rejEx;
        }
        catch (Exception e) {
            if ((e instanceof PasswordExpiredException || e instanceof SQLException && ((SQLException)e).getErrorCode() == 1820) && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) {
                return;
            }
            if (this.session != null) {
                this.session.forceClose();
            }
            connectionNotEstablishedBecause = e;
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e.getCause() != null && e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            if (e instanceof CJException) {
                throw (CJException)e;
            }
            SQLException chainedEx = SQLError.createSQLException(Messages.getString("Connection.UnableToConnect"), "08001", this.getExceptionInterceptor());
            chainedEx.initCause(connectionNotEstablishedBecause);
            throw chainedEx;
        }
    }

    private int getLoginTimeout() {
        int loginTimeoutSecs = DriverManager.getLoginTimeout();
        if (loginTimeoutSecs <= 0) {
            return 0;
        }
        return loginTimeoutSecs * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPreparedStatementCaches() throws SQLException {
        Lock connectionLock = this.getConnectionLock();
        connectionLock.lock();
        try {
            int cacheSize = this.propertySet.getIntegerProperty(PropertyKey.prepStmtCacheSize).getValue();
            String queryInfoCacheFactory = this.propertySet.getStringProperty(PropertyKey.queryInfoCacheFactory).getValue();
            CacheAdapterFactory cacheFactory = Util.getInstance(CacheAdapterFactory.class, queryInfoCacheFactory, null, null, this.getExceptionInterceptor());
            this.queryInfoCache = cacheFactory.getInstance(connectionLock, this.origHostInfo.getDatabaseUrl(), cacheSize, this.prepStmtCacheSqlLimit.getValue());
            if (this.useServerPrepStmts.getValue().booleanValue()) {
                this.serverSideStatementCheckCache = new LRUCache(cacheSize);
                this.serverSideStatementCache = new LRUCache<CompoundCacheKey, ServerPreparedStatement>(cacheSize){
                    private static final long serialVersionUID = 7692318650375988114L;

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<CompoundCacheKey, ServerPreparedStatement> eldest) {
                        if (this.maxElements <= 1) {
                            return false;
                        }
                        boolean removeIt = super.removeEldestEntry(eldest);
                        if (removeIt) {
                            ServerPreparedStatement ps = eldest.getValue();
                            ps.isCached = false;
                            ps.setClosed(false);
                            try {
                                ps.doClose(CloseOption.PROPAGATE, CloseOption.NO_CACHE);
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        return removeIt;
                    }
                };
            }
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.createStatement(1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkClosed();
            StatementImpl stmt = new StatementImpl(this.getMultiHostSafeProxy(), this.database);
            stmt.setResultSetType(resultSetType);
            stmt.setResultSetConcurrency(resultSetConcurrency);
            return stmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009", this.getExceptionInterceptor());
            }
            return this.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getActiveStatementCount() {
        return this.openStatements.size();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                boolean bl = this.session.getServerSession().isAutoCommit();
                return bl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                String string = this.propertySet.getEnumProperty(PropertyKey.databaseTerm).getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? null : this.database;
                return string;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCharacterSetMetadata() {
        Lock connectionLock = this.getConnectionLock();
        connectionLock.lock();
        try {
            String string = this.session.getServerSession().getCharsetSettings().getMetadataEncoding();
            return string;
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return 2;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long getId() {
        return this.session.getThreadId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getIdleFor() {
        Lock connectionLock = this.getConnectionLock();
        connectionLock.lock();
        try {
            long l = this.session.getIdleFor();
            return l;
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getMetaData(true, true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private java.sql.DatabaseMetaData getMetaData(boolean checkClosed, boolean checkForInfoSchema) throws SQLException {
        try {
            if (checkClosed) {
                this.checkClosed();
            }
            DatabaseMetaData dbmeta = DatabaseMetaData.getInstance(this.getMultiHostSafeProxy(), this.database, checkForInfoSchema, this.nullStatementResultSetFactory);
            if (this.getSession() != null && this.getSession().getProtocol() != null) {
                dbmeta.setMetadataEncoding(this.getSession().getServerSession().getCharsetSettings().getMetadataEncoding());
                dbmeta.setMetadataCollationIndex(this.getSession().getServerSession().getCharsetSettings().getMetadataCollationIndex());
            }
            return dbmeta;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Statement getMetadataSafeStatement() throws SQLException {
        try {
            return this.getMetadataSafeStatement(0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public Statement getMetadataSafeStatement(int maxRows) throws SQLException {
        Statement stmt = this.createStatement();
        stmt.setMaxRows(maxRows == -1 ? 0 : maxRows);
        stmt.setEscapeProcessing(false);
        if (stmt.getFetchSize() != 0) {
            stmt.setFetchSize(0);
        }
        return stmt;
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.session.getServerSession().getServerVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (!this.useLocalSessionState.getValue().booleanValue()) {
                    String s = this.session.queryServerVariable(this.versionMeetsMinimum(8, 0, 3) || this.versionMeetsMinimum(5, 7, 20) && !this.versionMeetsMinimum(8, 0, 0) ? "@@session.transaction_isolation" : "@@session.tx_isolation");
                    if (s != null) {
                        Integer intTI = mapTransIsolationNameToValue.get(s);
                        if (intTI != null) {
                            int n = this.isolationLevel = intTI.intValue();
                            return n;
                        }
                        throw SQLError.createSQLException(Messages.getString("Connection.12", new Object[]{s}), "S1000", this.getExceptionInterceptor());
                    }
                    throw SQLError.createSQLException(Messages.getString("Connection.13"), "S1000", this.getExceptionInterceptor());
                }
                int n = this.isolationLevel;
                return n;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (this.typeMap == null) {
                    this.typeMap = new HashMap();
                }
                Map<String, Class<?>> map = this.typeMap;
                return map;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getURL() {
        return this.origHostInfo.getDatabaseUrl();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean hasSameProperties(JdbcConnection c) {
        return this.props.equals(c.getProperties());
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    private void initializePropsFromServer() throws SQLException {
        String connectionInterceptorClasses = this.propertySet.getStringProperty(PropertyKey.connectionLifecycleInterceptors).getStringValue();
        this.connectionLifecycleInterceptors = null;
        if (connectionInterceptorClasses != null) {
            try {
                this.connectionLifecycleInterceptors = Util.loadClasses(ConnectionLifecycleInterceptor.class, connectionInterceptorClasses, "Connection.badLifecycleInterceptor", this.getExceptionInterceptor()).stream().map(i -> i.init(this, this.props, this.session.getLog())).collect(Collectors.toCollection(LinkedList::new));
            }
            catch (CJException e) {
                throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
            }
        }
        this.session.setSessionVariables();
        this.session.loadServerVariables(this.getConnectionLock(), this.dbmd.getDriverVersion());
        this.autoIncrementIncrement = this.session.getServerSession().getServerVariable("auto_increment_increment", 1);
        try {
            LicenseConfiguration.checkLicenseType(this.session.getServerSession().getServerVariables());
        }
        catch (CJException e) {
            throw SQLError.createSQLException(e.getMessage(), "08001", this.getExceptionInterceptor());
        }
        this.session.getProtocol().initServerSession();
        this.checkTransactionIsolationLevel();
        this.handleAutoCommitDefaults();
        ((DatabaseMetaData)this.dbmd).setMetadataEncoding(this.session.getServerSession().getCharsetSettings().getMetadataEncoding());
        ((DatabaseMetaData)this.dbmd).setMetadataCollationIndex(this.session.getServerSession().getCharsetSettings().getMetadataCollationIndex());
        this.setupServerForTruncationChecks();
    }

    private void handleAutoCommitDefaults() throws SQLException {
        try {
            block9: {
                boolean resetAutoCommitDefault = false;
                String initConnectValue = this.session.getServerSession().getServerVariable("init_connect");
                if (initConnectValue != null && initConnectValue.length() > 0) {
                    String s = this.session.queryServerVariable("@@session.autocommit");
                    if (s != null) {
                        this.session.getServerSession().setAutoCommit(Boolean.parseBoolean(s));
                        if (!this.session.getServerSession().isAutoCommit()) {
                            resetAutoCommitDefault = true;
                        }
                    }
                } else {
                    resetAutoCommitDefault = true;
                }
                if (resetAutoCommitDefault) {
                    try {
                        this.setAutoCommit(true);
                    }
                    catch (SQLException ex) {
                        if (ex.getErrorCode() == 1820 && !this.disconnectOnExpiredPasswords.getValue().booleanValue()) break block9;
                        throw ex;
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return this.session.isClosed();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isInGlobalTx() {
        return this.isInGlobalTx;
    }

    @Override
    public boolean isSourceConnection() {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.isReadOnly(true);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isReadOnly(boolean useSessionStatus) throws SQLException {
        try {
            String s;
            if (useSessionStatus && !this.session.isClosed() && this.versionMeetsMinimum(5, 6, 5) && !this.useLocalSessionState.getValue().booleanValue() && this.readOnlyPropagatesToServer.getValue().booleanValue() && (s = this.session.queryServerVariable(this.versionMeetsMinimum(8, 0, 3) || this.versionMeetsMinimum(5, 7, 20) && !this.versionMeetsMinimum(8, 0, 0) ? "@@session.transaction_read_only" : "@@session.tx_read_only")) != null) {
                return Integer.parseInt(s) != 0;
            }
            return this.readOnly;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameResource(JdbcConnection otherConnection) {
        Lock connectionLock = this.getConnectionLock();
        connectionLock.lock();
        try {
            if (otherConnection == null) {
                boolean bl = false;
                return bl;
            }
            boolean directCompare = true;
            String otherHost = ((ConnectionImpl)otherConnection).origHostToConnectTo;
            String otherOrigDatabase = ((ConnectionImpl)otherConnection).origHostInfo.getDatabase();
            String otherCurrentDb = ((ConnectionImpl)otherConnection).database;
            if (!StringUtils.nullSafeEqual(otherHost, this.origHostToConnectTo)) {
                directCompare = false;
            } else if (otherHost != null && otherHost.indexOf(44) == -1 && otherHost.indexOf(58) == -1) {
                boolean bl = directCompare = ((ConnectionImpl)otherConnection).origPortToConnectTo == this.origPortToConnectTo;
            }
            if (!(!directCompare || StringUtils.nullSafeEqual(otherOrigDatabase, this.origHostInfo.getDatabase()) && StringUtils.nullSafeEqual(otherCurrentDb, this.database))) {
                directCompare = false;
            }
            if (directCompare) {
                boolean bl = true;
                return bl;
            }
            String otherResourceId = ((ConnectionImpl)otherConnection).getPropertySet().getStringProperty(PropertyKey.resourceId).getValue();
            String myResourceId = this.propertySet.getStringProperty(PropertyKey.resourceId).getValue();
            if ((otherResourceId != null || myResourceId != null) && (directCompare = StringUtils.nullSafeEqual(otherResourceId, myResourceId))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public int getAutoIncrementIncrement() {
        return this.autoIncrementIncrement;
    }

    @Override
    public boolean lowerCaseTableNames() {
        return this.session.getServerSession().isLowerCaseTableNames();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            if (sql == null) {
                return null;
            }
            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.getMultiHostSafeProxy().getSession().getServerSession().getSessionTimeZone(), this.getMultiHostSafeProxy().getSession().getServerSession().getCapabilities().serverSupportsFracSecs(), this.getMultiHostSafeProxy().getSession().getServerSession().isServerTruncatesFracSecs(), this.getExceptionInterceptor());
            if (escapedSqlResult instanceof String) {
                return (String)escapedSqlResult;
            }
            return ((EscapeProcessorResult)escapedSqlResult).escapedSql;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private CallableStatement parseCallableStatement(String sql) throws SQLException {
        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.getMultiHostSafeProxy().getSession().getServerSession().getSessionTimeZone(), this.getMultiHostSafeProxy().getSession().getServerSession().getCapabilities().serverSupportsFracSecs(), this.getMultiHostSafeProxy().getSession().getServerSession().isServerTruncatesFracSecs(), this.getExceptionInterceptor());
        boolean isFunctionCall = false;
        String parsedSql = null;
        if (escapedSqlResult instanceof EscapeProcessorResult) {
            parsedSql = ((EscapeProcessorResult)escapedSqlResult).escapedSql;
            isFunctionCall = ((EscapeProcessorResult)escapedSqlResult).callingStoredFunction;
        } else {
            parsedSql = (String)escapedSqlResult;
            isFunctionCall = false;
        }
        return CallableStatement.getInstance(this.getMultiHostSafeProxy(), parsedSql, this.database, isFunctionCall);
    }

    @Override
    public void ping() throws SQLException {
        try {
            this.pingInternal(true, 0);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void pingInternal(boolean checkForClosedConnection, int timeoutMillis) throws SQLException {
        try {
            this.session.ping(checkForClosedConnection, timeoutMillis);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.prepareCall(sql, 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException(Messages.getString("Connection.17"), "S1009", this.getExceptionInterceptor());
            }
            CallableStatement cStmt = (CallableStatement)this.prepareCall(sql, resultSetType, resultSetConcurrency);
            return cStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.prepareStatement(sql, 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            PreparedStatement pStmt = this.prepareStatement(sql);
            ((ClientPreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException(Messages.getString("Connection.17"), "S1009", this.getExceptionInterceptor());
            }
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            PreparedStatement pStmt = this.prepareStatement(sql);
            ((ClientPreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            PreparedStatement pStmt = this.prepareStatement(sql);
            ((ClientPreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose(Throwable reason, CloseOption ... options) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (this.isClosed()) {
                    return;
                }
                SQLException sqlEx = null;
                this.session.setForceClosedReason(reason);
                try {
                    if (this.propertySet.getBooleanProperty(PropertyKey.gatherPerfMetrics).getValue().booleanValue()) {
                        this.session.getProtocol().getMetricsHolder().reportMetrics(this.session.getLog());
                    }
                    if (this.useUsageAdvisor.getValue().booleanValue()) {
                        if (CloseOption.IMPLICIT.in(options)) {
                            this.session.getProfilerEventHandler().processEvent((byte)0, this.session, null, null, 0L, new Throwable(), Messages.getString("Connection.18"));
                        }
                        if (System.currentTimeMillis() - this.session.getConnectionCreationTimeMillis() < 500L) {
                            this.session.getProfilerEventHandler().processEvent((byte)0, this.session, null, null, 0L, new Throwable(), Messages.getString("Connection.19"));
                        }
                    }
                    if (!this.getAutoCommit() && CloseOption.ROLLBACK.in(options)) {
                        try {
                            this.rollback();
                        }
                        catch (SQLException e) {
                            sqlEx = e;
                        }
                    }
                    if (CloseOption.PROPAGATE.in(options)) {
                        try {
                            this.closeAllOpenStatements();
                        }
                        catch (SQLException ex) {
                            sqlEx = ex;
                        }
                    }
                    if (CloseOption.FORCED.in(options)) {
                        this.session.forceClose();
                    } else {
                        this.session.quit();
                    }
                    if (this.queryInterceptors != null) {
                        this.queryInterceptors.forEach(QueryInterceptor::destroy);
                    }
                    if (this.exceptionInterceptor != null) {
                        this.exceptionInterceptor.destroy();
                    }
                }
                finally {
                    this.openStatements.clear();
                    this.queryInterceptors = null;
                    this.exceptionInterceptor = null;
                    this.nullStatementResultSetFactory = null;
                    this.session.getTelemetryHandler().removeLinkTarget(this.connectionSpan);
                }
                if (sqlEx != null) {
                    throw sqlEx;
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recachePreparedStatement(JdbcPreparedStatement pstmt) throws SQLException {
        try {
            block9: {
                Lock connectionLock = this.getConnectionLock();
                connectionLock.lock();
                try {
                    if (!this.cachePrepStmts.getValue().booleanValue() || !pstmt.isPoolable()) break block9;
                    this.serverSideStatementCheckCacheLock.lock();
                    try {
                        ServerPreparedStatement oldServerPrepStmt = this.serverSideStatementCache.put(new CompoundCacheKey(pstmt.getCurrentDatabase(), ((PreparedQuery)pstmt.getQuery()).getOriginalSql()), (ServerPreparedStatement)pstmt);
                        if (oldServerPrepStmt != null && oldServerPrepStmt != pstmt) {
                            oldServerPrepStmt.isCached = false;
                            oldServerPrepStmt.setClosed(false);
                            oldServerPrepStmt.doClose(CloseOption.PROPAGATE, CloseOption.NO_CACHE);
                        }
                    }
                    finally {
                        this.serverSideStatementCheckCacheLock.unlock();
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decachePreparedStatement(JdbcPreparedStatement pstmt) throws SQLException {
        try {
            block8: {
                Lock connectionLock = this.getConnectionLock();
                connectionLock.lock();
                try {
                    if (!this.cachePrepStmts.getValue().booleanValue()) break block8;
                    this.serverSideStatementCheckCacheLock.lock();
                    try {
                        this.serverSideStatementCache.remove(new CompoundCacheKey(pstmt.getCurrentDatabase(), ((PreparedQuery)pstmt.getQuery()).getOriginalSql()));
                    }
                    finally {
                        this.serverSideStatementCheckCacheLock.unlock();
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void registerStatement(JdbcStatement stmt) {
        this.openStatements.addIfAbsent(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                StringBuilder releaseSavepointQuery = new StringBuilder("RELEASE SAVEPOINT ");
                releaseSavepointQuery.append(StringUtils.quoteIdentifier(savepoint.getSavepointName(), this.session.getIdentifierQuoteString(), this.pedantic.getValue()));
                Statement stmt = null;
                try {
                    stmt = this.getMetadataSafeStatement();
                    stmt.executeUpdate(releaseSavepointQuery.toString());
                }
                finally {
                    this.closeStatement(stmt);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void resetServerState() throws SQLException {
        try {
            if (!this.propertySet.getBooleanProperty(PropertyKey.paranoid).getValue().booleanValue() && this.session != null) {
                TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.CONNECTION_RESET, new Object[0]);
                try (TelemetryScope scope = span.makeCurrent();){
                    span.setAttribute(TelemetryAttribute.DB_CONNECTION_STRING, this.getURL());
                    span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                    span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                    span.setAttribute(TelemetryAttribute.SERVER_ADDRESS, this.origHostToConnectTo);
                    span.setAttribute(TelemetryAttribute.SERVER_PORT, this.origPortToConnectTo);
                    span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                    span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                    this.session.getServerSession().getCharsetSettings().configurePreHandshake(true);
                    this.session.resetSessionState();
                    this.session.getServerSession().getCharsetSettings().configurePostHandshake(true);
                    this.session.setSessionVariables();
                    this.handleAutoCommitDefaults();
                    this.setupServerForTruncationChecks();
                }
                catch (Throwable t) {
                    span.setError(t);
                    throw t;
                }
                finally {
                    span.end();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                try {
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock<ConnectionLifecycleInterceptor> iter = new IterateBlock<ConnectionLifecycleInterceptor>(this.connectionLifecycleInterceptors.iterator()){

                            @Override
                            void forEach(ConnectionLifecycleInterceptor each) throws SQLException {
                                if (!each.rollback()) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            return;
                        }
                    }
                    if (this.session.getServerSession().isAutoCommit()) {
                        throw SQLError.createSQLException(Messages.getString("Connection.20"), "08003", this.getExceptionInterceptor());
                    }
                    try {
                        this.rollbackNoChecks();
                    }
                    catch (SQLException sqlEx) {
                        if (this.ignoreNonTxTables.getInitialValue().booleanValue() && sqlEx.getErrorCode() == 1196) {
                            this.session.setNeedsPing(this.reconnectAtTxEnd.getValue());
                            connectionLock.unlock();
                            return;
                        }
                        try {
                            throw sqlEx;
                        }
                        catch (SQLException sqlException) {
                            if ("08S01".equals(sqlException.getSQLState())) {
                                throw SQLError.createSQLException(Messages.getString("Connection.21"), "08007", this.getExceptionInterceptor());
                            }
                            throw sqlException;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.session.setNeedsPing(this.reconnectAtTxEnd.getValue());
                }
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(final Savepoint savepoint) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                try {
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock<ConnectionLifecycleInterceptor> iter = new IterateBlock<ConnectionLifecycleInterceptor>(this.connectionLifecycleInterceptors.iterator()){

                            @Override
                            void forEach(ConnectionLifecycleInterceptor each) throws SQLException {
                                if (!each.rollback(savepoint)) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            return;
                        }
                    }
                    StringBuilder rollbackQuery = new StringBuilder("ROLLBACK TO SAVEPOINT ");
                    rollbackQuery.append(StringUtils.quoteIdentifier(savepoint.getSavepointName(), this.session.getIdentifierQuoteString(), this.pedantic.getValue()));
                    Statement stmt = null;
                    try {
                        stmt = this.getMetadataSafeStatement();
                        stmt.executeUpdate(rollbackQuery.toString());
                    }
                    catch (SQLException sqlEx) {
                        int indexOfError153;
                        String msg;
                        int errno = sqlEx.getErrorCode();
                        if (errno == 1181 && (msg = sqlEx.getMessage()) != null && (indexOfError153 = msg.indexOf("153")) != -1) {
                            throw SQLError.createSQLException(Messages.getString("Connection.22", new Object[]{savepoint.getSavepointName()}), "S1009", errno, this.getExceptionInterceptor());
                        }
                        if (this.ignoreNonTxTables.getValue().booleanValue() && sqlEx.getErrorCode() != 1196) {
                            throw sqlEx;
                        }
                        if ("08S01".equals(sqlEx.getSQLState())) {
                            throw SQLError.createSQLException(Messages.getString("Connection.23"), "08007", this.getExceptionInterceptor());
                        }
                        throw sqlEx;
                    }
                    finally {
                        this.closeStatement(stmt);
                    }
                }
                finally {
                    this.session.setNeedsPing(this.reconnectAtTxEnd.getValue());
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackNoChecks() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (this.useLocalTransactionState.getValue().booleanValue() && !this.session.getServerSession().inTransactionOnServer()) {
                    return;
                }
                TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.ROLLBACK, new Object[0]);
                try (TelemetryScope scope = span.makeCurrent();){
                    span.setAttribute(TelemetryAttribute.DB_NAME, this.getDatabase());
                    span.setAttribute(TelemetryAttribute.DB_OPERATION, "ROLLBACK");
                    span.setAttribute(TelemetryAttribute.DB_STATEMENT, "ROLLBACK");
                    span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                    span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                    span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                    span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                    this.session.execSQL(null, "ROLLBACK", -1, null, false, this.nullStatementResultSetFactory, null, false);
                }
                catch (Throwable t) {
                    span.setError(t);
                    throw t;
                }
                finally {
                    span.end();
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql) throws SQLException {
        try {
            String nativeSql = this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            return ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.getDatabase(), 1003, 1007);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            String nativeSql = this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            ServerPreparedStatement pStmt = ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.getDatabase(), 1003, 1007);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String nativeSql = this.processEscapeCodesForPrepStmts.getValue() != false ? this.nativeSQL(sql) : sql;
            return ServerPreparedStatement.getInstance(this.getMultiHostSafeProxy(), nativeSql, this.getDatabase(), resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.pedantic.getValue().booleanValue() && resultSetHoldability != 1) {
                throw SQLError.createSQLException(Messages.getString("Connection.17"), "S1009", this.getExceptionInterceptor());
            }
            return this.serverPrepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            ClientPreparedStatement pStmt = (ClientPreparedStatement)this.serverPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            ClientPreparedStatement pStmt = (ClientPreparedStatement)this.serverPrepareStatement(sql);
            pStmt.setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
            return pStmt;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(final boolean autoCommitFlag) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                block36: {
                    this.checkClosed();
                    if (this.connectionLifecycleInterceptors != null) {
                        IterateBlock<ConnectionLifecycleInterceptor> iter = new IterateBlock<ConnectionLifecycleInterceptor>(this.connectionLifecycleInterceptors.iterator()){

                            @Override
                            void forEach(ConnectionLifecycleInterceptor each) throws SQLException {
                                if (!each.setAutoCommit(autoCommitFlag)) {
                                    this.stopIterating = true;
                                }
                            }
                        };
                        iter.doForAll();
                        if (!iter.fullIteration()) {
                            return;
                        }
                    }
                    if (this.autoReconnectForPools.getValue().booleanValue()) {
                        this.autoReconnect.setValue(true);
                    }
                    boolean isAutoCommit = this.session.getServerSession().isAutoCommit();
                    try {
                        boolean needsSetOnServer = true;
                        if (this.useLocalSessionState.getValue().booleanValue() && isAutoCommit == autoCommitFlag) {
                            needsSetOnServer = false;
                        } else if (!this.autoReconnect.getValue().booleanValue()) {
                            needsSetOnServer = this.getSession().isSetNeededForAutoCommitMode(autoCommitFlag);
                        }
                        this.session.getServerSession().setAutoCommit(autoCommitFlag);
                        if (!needsSetOnServer) break block36;
                        TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.SET_VARIABLE, "autocommit");
                        try (TelemetryScope scope = span.makeCurrent();){
                            span.setAttribute(TelemetryAttribute.DB_NAME, this.getDatabase());
                            span.setAttribute(TelemetryAttribute.DB_OPERATION, "SET");
                            span.setAttribute(TelemetryAttribute.DB_STATEMENT, "SET (...)");
                            span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                            span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                            span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                            span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                            this.session.execSQL(null, autoCommitFlag ? "SET autocommit=1" : "SET autocommit=0", -1, null, false, this.nullStatementResultSetFactory, null, false);
                        }
                        catch (Throwable t) {
                            span.setError(t);
                            throw t;
                        }
                        finally {
                            span.end();
                        }
                    }
                    catch (CJCommunicationsException e) {
                        throw e;
                    }
                    catch (CJException e) {
                        this.session.getServerSession().setAutoCommit(isAutoCommit);
                        throw SQLError.createSQLException(e.getMessage(), e.getSQLState(), e.getVendorCode(), e.isTransient(), e, this.getExceptionInterceptor());
                    }
                    finally {
                        if (this.autoReconnectForPools.getValue().booleanValue()) {
                            this.autoReconnect.setValue(false);
                        }
                    }
                }
                return;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            if (this.propertySet.getEnumProperty(PropertyKey.databaseTerm).getValue() == PropertyDefinitions.DatabaseTerm.CATALOG) {
                this.setDatabase(catalog);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDatabase(final String db) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                if (db == null) {
                    throw SQLError.createSQLException("Database can not be null", "S1009", this.getExceptionInterceptor());
                }
                if (this.connectionLifecycleInterceptors != null) {
                    IterateBlock<ConnectionLifecycleInterceptor> iter = new IterateBlock<ConnectionLifecycleInterceptor>(this.connectionLifecycleInterceptors.iterator()){

                        @Override
                        void forEach(ConnectionLifecycleInterceptor each) throws SQLException {
                            if (!each.setDatabase(db)) {
                                this.stopIterating = true;
                            }
                        }
                    };
                    iter.doForAll();
                    if (!iter.fullIteration()) {
                        return;
                    }
                }
                if (this.useLocalSessionState.getValue().booleanValue() && (this.session.getServerSession().isLowerCaseTableNames() ? this.database.equalsIgnoreCase(db) : this.database.equals(db))) {
                    return;
                }
                TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.USE_DATABASE, new Object[0]);
                try (TelemetryScope scope = span.makeCurrent();){
                    span.setAttribute(TelemetryAttribute.DB_NAME, db);
                    span.setAttribute(TelemetryAttribute.DB_OPERATION, "USE");
                    span.setAttribute(TelemetryAttribute.DB_STATEMENT, "USE (...)");
                    span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                    span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                    span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                    span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                    String quotedId = this.session.getIdentifierQuoteString();
                    StringBuilder query = new StringBuilder("USE ");
                    query.append(StringUtils.quoteIdentifier(db, quotedId, this.pedantic.getValue()));
                    this.session.execSQL(null, query.toString(), -1, null, false, this.nullStatementResultSetFactory, null, false);
                    this.database = db;
                }
                catch (Throwable t) {
                    span.setError(t);
                    throw t;
                }
                finally {
                    span.end();
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getDatabase() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                String string = this.database;
                return string;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFailedOver(boolean flag) {
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setInGlobalTx(boolean flag) {
        this.isInGlobalTx = flag;
    }

    @Override
    public void setReadOnly(boolean readOnlyFlag) throws SQLException {
        try {
            this.checkClosed();
            this.setReadOnlyInternal(readOnlyFlag);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnlyInternal(boolean readOnlyFlag) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (this.readOnlyPropagatesToServer.getValue().booleanValue() && this.versionMeetsMinimum(5, 6, 5) && (!this.useLocalSessionState.getValue().booleanValue() || readOnlyFlag != this.readOnly)) {
                    TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.SET_TRANSACTION_ACCESS_MODE, readOnlyFlag ? "read-only" : "read-write");
                    try (TelemetryScope scope = span.makeCurrent();){
                        span.setAttribute(TelemetryAttribute.DB_NAME, this.getDatabase());
                        span.setAttribute(TelemetryAttribute.DB_OPERATION, "SET");
                        span.setAttribute(TelemetryAttribute.DB_STATEMENT, "SET (...)");
                        span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                        span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                        span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                        span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                        this.session.execSQL(null, "SET SESSION TRANSACTION " + (readOnlyFlag ? "READ ONLY" : "READ WRITE"), -1, null, false, this.nullStatementResultSetFactory, null, false);
                    }
                    catch (Throwable t) {
                        span.setError(t);
                        throw t;
                    }
                    finally {
                        span.end();
                    }
                }
                this.readOnly = readOnlyFlag;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            MysqlSavepoint savepoint = new MysqlSavepoint(this.getExceptionInterceptor());
            this.setSavepoint(savepoint);
            return savepoint;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSavepoint(MysqlSavepoint savepoint) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                StringBuilder savePointQuery = new StringBuilder("SAVEPOINT ");
                savePointQuery.append(StringUtils.quoteIdentifier(savepoint.getSavepointName(), this.session.getIdentifierQuoteString(), this.pedantic.getValue()));
                Statement stmt = null;
                try {
                    stmt = this.getMetadataSafeStatement();
                    stmt.executeUpdate(savePointQuery.toString());
                }
                finally {
                    this.closeStatement(stmt);
                }
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                MysqlSavepoint savepoint = new MysqlSavepoint(name, this.getExceptionInterceptor());
                this.setSavepoint(savepoint);
                MysqlSavepoint mysqlSavepoint = savepoint;
                return mysqlSavepoint;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            block33: {
                Lock connectionLock = this.getConnectionLock();
                connectionLock.lock();
                try {
                    this.checkClosed();
                    String sql = null;
                    boolean shouldSendSet = false;
                    if (this.propertySet.getBooleanProperty(PropertyKey.alwaysSendSetIsolation).getValue().booleanValue()) {
                        shouldSendSet = true;
                    } else if (level != this.isolationLevel) {
                        shouldSendSet = true;
                    }
                    if (this.useLocalSessionState.getValue().booleanValue()) {
                        boolean bl = shouldSendSet = this.isolationLevel != level;
                    }
                    if (!shouldSendSet) break block33;
                    TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.SET_TRANSACTION_ISOLATION, new Object[0]);
                    try (TelemetryScope scope = span.makeCurrent();){
                        span.setAttribute(TelemetryAttribute.DB_NAME, this.getDatabase());
                        span.setAttribute(TelemetryAttribute.DB_OPERATION, "SET");
                        span.setAttribute(TelemetryAttribute.DB_STATEMENT, "SET (...)");
                        span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                        span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                        span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                        span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                        switch (level) {
                            case 0: {
                                throw SQLError.createSQLException(Messages.getString("Connection.24"), this.getExceptionInterceptor());
                            }
                            case 2: {
                                sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ COMMITTED";
                                break;
                            }
                            case 1: {
                                sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ UNCOMMITTED";
                                break;
                            }
                            case 4: {
                                sql = "SET SESSION TRANSACTION ISOLATION LEVEL REPEATABLE READ";
                                break;
                            }
                            case 8: {
                                sql = "SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE";
                                break;
                            }
                            default: {
                                throw SQLError.createSQLException(Messages.getString("Connection.25", new Object[]{level}), "S1C00", this.getExceptionInterceptor());
                            }
                        }
                        this.session.execSQL(null, sql, -1, null, false, this.nullStatementResultSetFactory, null, false);
                        this.isolationLevel = level;
                    }
                    catch (Throwable t) {
                        span.setError(t);
                        throw t;
                    }
                    finally {
                        span.end();
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.typeMap = map;
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupServerForTruncationChecks() throws SQLException {
        try {
            block25: {
                Lock connectionLock = this.getConnectionLock();
                connectionLock.lock();
                try {
                    boolean strictTransTablesIsSet;
                    RuntimeProperty<Boolean> jdbcCompliantTruncation = this.propertySet.getProperty(PropertyKey.jdbcCompliantTruncation);
                    if (!((Boolean)jdbcCompliantTruncation.getValue()).booleanValue()) break block25;
                    String currentSqlMode = this.session.getServerSession().getServerVariable("sql_mode");
                    boolean bl = strictTransTablesIsSet = StringUtils.indexOfIgnoreCase(currentSqlMode, "STRICT_TRANS_TABLES") != -1;
                    if (currentSqlMode == null || currentSqlMode.length() == 0 || !strictTransTablesIsSet) {
                        TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.SET_VARIABLE, "sql_mode");
                        try (TelemetryScope scope = span.makeCurrent();){
                            span.setAttribute(TelemetryAttribute.DB_NAME, this.getDatabase());
                            span.setAttribute(TelemetryAttribute.DB_OPERATION, "SET");
                            span.setAttribute(TelemetryAttribute.DB_STATEMENT, "SET (...)");
                            span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                            span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                            span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                            span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                            StringBuilder commandBuf = new StringBuilder("SET sql_mode='");
                            if (currentSqlMode != null && currentSqlMode.length() > 0) {
                                commandBuf.append(currentSqlMode);
                                commandBuf.append(",");
                            }
                            commandBuf.append("STRICT_TRANS_TABLES'");
                            this.session.execSQL(null, commandBuf.toString(), -1, null, false, this.nullStatementResultSetFactory, null, false);
                            jdbcCompliantTruncation.setValue(false);
                            break block25;
                        }
                        catch (Throwable t) {
                            span.setError(t);
                            throw t;
                        }
                        finally {
                            span.end();
                        }
                    }
                    if (strictTransTablesIsSet) {
                        jdbcCompliantTruncation.setValue(false);
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void shutdownServer() throws SQLException {
        try {
            try {
                this.session.shutdownServer();
            }
            catch (CJException ex) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("Connection.UnhandledExceptionDuringShutdown"), "S1000", this.getExceptionInterceptor());
                sqlEx.initCause(ex);
                throw sqlEx;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void unregisterStatement(JdbcStatement stmt) {
        this.openStatements.remove(stmt);
    }

    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        try {
            this.checkClosed();
            return this.session.versionMeetsMinimum(major, minor, subminor);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public CachedResultSetMetaData getCachedMetaData(String sql) {
        if (this.resultSetMetadataCache != null) {
            this.resultSetMetadataCacheLock.lock();
            try {
                CachedResultSetMetaData cachedResultSetMetaData = (CachedResultSetMetaData)this.resultSetMetadataCache.get(sql);
                return cachedResultSetMetaData;
            }
            finally {
                this.resultSetMetadataCacheLock.unlock();
            }
        }
        return null;
    }

    @Override
    public void initializeResultsMetadataFromCache(String sql, CachedResultSetMetaData cachedMetaData, ResultSetInternalMethods resultSet) throws SQLException {
        try {
            if (cachedMetaData == null) {
                cachedMetaData = new CachedResultSetMetaDataImpl();
                resultSet.getColumnDefinition().buildIndexMapping();
                resultSet.initializeWithMetadata();
                if (resultSet instanceof UpdatableResultSet) {
                    ((UpdatableResultSet)resultSet).checkUpdatability();
                }
                resultSet.populateCachedMetaData(cachedMetaData);
                this.resultSetMetadataCache.put(sql, cachedMetaData);
            } else {
                resultSet.getColumnDefinition().initializeFrom(cachedMetaData);
                resultSet.initializeWithMetadata();
                if (resultSet instanceof UpdatableResultSet) {
                    ((UpdatableResultSet)resultSet).checkUpdatability();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getStatementComment() {
        return this.session.getQueryComment();
    }

    @Override
    public void setStatementComment(String comment) {
        this.session.setQueryComment(comment);
    }

    @Override
    public void transactionBegun() {
        Lock connectionLock = this.getConnectionLock();
        connectionLock.lock();
        try {
            if (this.connectionLifecycleInterceptors != null) {
                this.connectionLifecycleInterceptors.stream().forEach(ConnectionLifecycleInterceptor::transactionBegun);
            }
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public void transactionCompleted() {
        Lock connectionLock = this.getConnectionLock();
        connectionLock.lock();
        try {
            if (this.connectionLifecycleInterceptors != null) {
                this.connectionLifecycleInterceptors.stream().forEach(ConnectionLifecycleInterceptor::transactionCompleted);
            }
        }
        finally {
            connectionLock.unlock();
        }
    }

    @Override
    public boolean storesLowerCaseTableName() {
        return this.session.getServerSession().storesLowerCaseTableNames();
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public boolean isServerLocal() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                boolean bl = this.session.isServerLocal(this.getSession());
                return bl;
            }
            catch (CJException ex) {
                SQLException sqlEx = SQLExceptionsMapping.translateException(ex, this.getExceptionInterceptor());
                throw sqlEx;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getSessionMaxRows() {
        Lock connectionLock = this.getConnectionLock();
        connectionLock.lock();
        try {
            int n = this.session.getSessionMaxRows();
            return n;
        }
        finally {
            connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionMaxRows(int max) throws SQLException {
        try {
            block22: {
                Lock connectionLock = this.getConnectionLock();
                connectionLock.lock();
                try {
                    this.checkClosed();
                    if (this.session.getSessionMaxRows() == max) break block22;
                    TelemetrySpan span = this.session.getTelemetryHandler().startSpan(TelemetrySpanName.SET_VARIABLE, "sql_select_limit");
                    try (TelemetryScope scope = span.makeCurrent();){
                        span.setAttribute(TelemetryAttribute.DB_NAME, this.getDatabase());
                        span.setAttribute(TelemetryAttribute.DB_OPERATION, "SET");
                        span.setAttribute(TelemetryAttribute.DB_STATEMENT, "SET (...)");
                        span.setAttribute(TelemetryAttribute.DB_SYSTEM, "mysql");
                        span.setAttribute(TelemetryAttribute.DB_USER, this.getUser());
                        span.setAttribute(TelemetryAttribute.THREAD_ID, Thread.currentThread().getId());
                        span.setAttribute(TelemetryAttribute.THREAD_NAME, Thread.currentThread().getName());
                        this.session.setSessionMaxRows(max);
                        this.session.execSQL(null, "SET sql_select_limit=" + (this.session.getSessionMaxRows() == -1 ? "DEFAULT" : Integer.valueOf(this.session.getSessionMaxRows())), -1, null, false, this.nullStatementResultSetFactory, null, false);
                    }
                    catch (Throwable t) {
                        span.setError(t);
                        throw t;
                    }
                    finally {
                        span.end();
                    }
                }
                finally {
                    connectionLock.unlock();
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            this.checkClosed();
            if (this.propertySet.getEnumProperty(PropertyKey.databaseTerm).getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA) {
                this.setDatabase(schema);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                String string = this.propertySet.getEnumProperty(PropertyKey.databaseTerm).getValue() == PropertyDefinitions.DatabaseTerm.SCHEMA ? this.database : null;
                return string;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            SecurityManager sec = System.getSecurityManager();
            if (sec != null) {
                sec.checkPermission(ABORT_PERM);
            }
            if (executor == null) {
                throw SQLError.createSQLException(Messages.getString("Connection.26"), "S1009", this.getExceptionInterceptor());
            }
            executor.execute(() -> {
                try {
                    this.abortInternal();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                SecurityManager sec = System.getSecurityManager();
                if (sec != null) {
                    sec.checkPermission(SET_NETWORK_TIMEOUT_PERM);
                }
                if (executor == null) {
                    throw SQLError.createSQLException(Messages.getString("Connection.26"), "S1009", this.getExceptionInterceptor());
                }
                this.checkClosed();
                executor.execute(new NetworkTimeoutSetter(this, milliseconds));
            }
            finally {
                connectionLock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                this.checkClosed();
                int n = this.session.getSocketTimeout();
                return n;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Clob createClob() {
        try {
            return new Clob(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.Blob createBlob() {
        try {
            return new Blob(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public java.sql.NClob createNClob() {
        try {
            return new NClob(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return new MysqlSQLXML(this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (this.isClosed()) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.pingInternal(false, timeout * 1000);
                }
                catch (Throwable t) {
                    try {
                        this.abortInternal();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    boolean bl = false;
                    connectionLock.unlock();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientInfoProvider getClientInfoProviderImpl() throws SQLException {
        try {
            Lock connectionLock = this.getConnectionLock();
            connectionLock.lock();
            try {
                if (this.infoProvider == null) {
                    String clientInfoProvider = this.propertySet.getStringProperty(PropertyKey.clientInfoProvider).getStringValue();
                    try {
                        this.infoProvider = Util.getInstance(ClientInfoProvider.class, clientInfoProvider, null, null, this.getExceptionInterceptor());
                    }
                    catch (CJException e1) {
                        if (ClassNotFoundException.class.isInstance(e1.getCause())) {
                            try {
                                this.infoProvider = Util.getInstance(ClientInfoProvider.class, "dev.brighten.antivpn.shaded.com.mysql.cj.jdbc." + clientInfoProvider, null, null, this.getExceptionInterceptor());
                            }
                            catch (CJException e2) {
                                throw SQLExceptionsMapping.translateException(e1, this.getExceptionInterceptor());
                            }
                        }
                        throw SQLExceptionsMapping.translateException(e1, this.getExceptionInterceptor());
                    }
                    this.infoProvider.initialize(this, this.props);
                }
                ClientInfoProvider clientInfoProvider = this.infoProvider;
                return clientInfoProvider;
            }
            finally {
                connectionLock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, name, value);
        }
        catch (SQLClientInfoException ciEx) {
            throw ciEx;
        }
        catch (CJException | SQLException sqlEx) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(sqlEx);
            throw clientInfoEx;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, properties);
        }
        catch (SQLClientInfoException ciEx) {
            throw ciEx;
        }
        catch (CJException | SQLException sqlEx) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(sqlEx);
            throw clientInfoEx;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            return this.getClientInfoProviderImpl().getClientInfo(this, name);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getClientInfoProviderImpl().getClientInfo(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.checkClosed();
            return iface.isInstance(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public NativeSession getSession() {
        return this.session;
    }

    @Override
    public String getHostPortPair() {
        return this.origHostInfo.getHostPortPair();
    }

    @Override
    public void handleNormalClose() {
        try {
            this.close();
        }
        catch (SQLException e) {
            ExceptionFactory.createException(e.getMessage(), e);
        }
    }

    @Override
    public void handleReconnect() {
        this.createNewIO(true);
    }

    @Override
    public void handleCleanup(Throwable whyCleanedUp) {
        this.cleanup(whyCleanedUp);
    }

    @Override
    public ServerSessionStateController getServerSessionStateController() {
        return this.session.getServerSession().getServerSessionStateController();
    }

    static {
        mapTransIsolationNameToValue = new HashMap<String, Integer>(8);
        mapTransIsolationNameToValue.put("READ-UNCOMMITED", 1);
        mapTransIsolationNameToValue.put("READ-UNCOMMITTED", 1);
        mapTransIsolationNameToValue.put("READ-COMMITTED", 2);
        mapTransIsolationNameToValue.put("REPEATABLE-READ", 4);
        mapTransIsolationNameToValue.put("SERIALIZABLE", 8);
    }

    private static class NetworkTimeoutSetter
    implements Runnable {
        private final WeakReference<JdbcConnection> connRef;
        private final int milliseconds;

        public NetworkTimeoutSetter(JdbcConnection conn, int milliseconds) {
            this.connRef = new WeakReference<JdbcConnection>(conn);
            this.milliseconds = milliseconds;
        }

        @Override
        public void run() {
            JdbcConnection conn = (JdbcConnection)this.connRef.get();
            if (conn != null) {
                Lock connectionLock = conn.getConnectionLock();
                connectionLock.lock();
                try {
                    ((NativeSession)conn.getSession()).setSocketTimeout(this.milliseconds);
                }
                finally {
                    connectionLock.unlock();
                }
            }
        }
    }

    static class CompoundCacheKey {
        final String componentOne;
        final String componentTwo;
        final int hashCode;

        CompoundCacheKey(String partOne, String partTwo) {
            this.componentOne = partOne;
            this.componentTwo = partTwo;
            int hc = 17;
            hc = 31 * hc + (this.componentOne != null ? this.componentOne.hashCode() : 0);
            this.hashCode = hc = 31 * hc + (this.componentTwo != null ? this.componentTwo.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && CompoundCacheKey.class.isAssignableFrom(obj.getClass())) {
                CompoundCacheKey another = (CompoundCacheKey)obj;
                if (this.componentOne == null ? another.componentOne == null : this.componentOne.equals(another.componentOne)) {
                    return this.componentTwo == null ? another.componentTwo == null : this.componentTwo.equals(another.componentTwo);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

