/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha;

import dev.brighten.antivpn.shaded.com.mysql.cj.Messages;
import dev.brighten.antivpn.shaded.com.mysql.cj.PingTarget;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.ConnectionUrl;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.HostInfo;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.HostsListView;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.PropertyKey;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.url.LoadBalanceConnectionUrl;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.url.ReplicationConnectionUrl;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.JdbcConnection;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.JdbcStatement;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.exceptions.SQLError;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.LoadBalancedConnection;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.MultiHostConnectionProxy;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.ReplicationConnection;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.ReplicationConnectionGroup;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.ReplicationConnectionGroupManager;
import dev.brighten.antivpn.shaded.com.mysql.cj.jdbc.ha.ReplicationMySQLConnection;
import dev.brighten.antivpn.shaded.com.mysql.cj.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ReplicationConnectionProxy
extends MultiHostConnectionProxy
implements PingTarget {
    private ReplicationConnection thisAsReplicationConnection;
    protected boolean enableJMX;
    protected boolean allowSourceDownConnections;
    protected boolean allowReplicaDownConnections;
    protected boolean readFromSourceWhenNoReplicas;
    protected boolean readFromSourceWhenNoReplicasOriginal;
    protected boolean readOnly;
    ReplicationConnectionGroup connectionGroup;
    private long connectionGroupID;
    private List<HostInfo> sourceHosts;
    protected LoadBalancedConnection sourceConnection;
    private List<HostInfo> replicaHosts;
    protected LoadBalancedConnection replicasConnection;

    public static ReplicationConnection createProxyInstance(ConnectionUrl connectionUrl) throws SQLException {
        ReplicationConnectionProxy connProxy = new ReplicationConnectionProxy(connectionUrl);
        return (ReplicationConnection)Proxy.newProxyInstance(ReplicationConnection.class.getClassLoader(), new Class[]{ReplicationConnection.class, JdbcConnection.class}, (InvocationHandler)connProxy);
    }

    private ReplicationConnectionProxy(ConnectionUrl connectionUrl) throws SQLException {
        block21: {
            this.enableJMX = false;
            this.allowSourceDownConnections = false;
            this.allowReplicaDownConnections = false;
            this.readFromSourceWhenNoReplicas = false;
            this.readFromSourceWhenNoReplicasOriginal = false;
            this.readOnly = false;
            this.connectionGroupID = -1L;
            Properties props = connectionUrl.getConnectionArgumentsAsProperties();
            this.thisAsReplicationConnection = (ReplicationConnection)this.thisAsConnection;
            this.connectionUrl = connectionUrl;
            String enableJMXAsString = props.getProperty(PropertyKey.ha_enableJMX.getKeyName(), "false");
            try {
                this.enableJMX = Boolean.parseBoolean(enableJMXAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("MultihostConnection.badValueForHaEnableJMX", new Object[]{enableJMXAsString}), "S1009", null);
            }
            String allowSourceDownConnectionsAsString = props.getProperty(PropertyKey.allowSourceDownConnections.getKeyName(), "false");
            try {
                this.allowSourceDownConnections = Boolean.parseBoolean(allowSourceDownConnectionsAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.badValueForAllowSourceDownConnections", new Object[]{enableJMXAsString}), "S1009", null);
            }
            String allowReplicaDownConnectionsAsString = props.getProperty(PropertyKey.allowReplicaDownConnections.getKeyName(), "false");
            try {
                this.allowReplicaDownConnections = Boolean.parseBoolean(allowReplicaDownConnectionsAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.badValueForAllowReplicaDownConnections", new Object[]{allowReplicaDownConnectionsAsString}), "S1009", null);
            }
            String readFromSourceWhenNoReplicasAsString = props.getProperty(PropertyKey.readFromSourceWhenNoReplicas.getKeyName());
            try {
                this.readFromSourceWhenNoReplicasOriginal = Boolean.parseBoolean(readFromSourceWhenNoReplicasAsString);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.badValueForReadFromSourceWhenNoReplicas", new Object[]{readFromSourceWhenNoReplicasAsString}), "S1009", null);
            }
            String group = props.getProperty(PropertyKey.replicationConnectionGroup.getKeyName(), null);
            if (!StringUtils.isNullOrEmpty(group) && ReplicationConnectionUrl.class.isAssignableFrom(connectionUrl.getClass())) {
                this.connectionGroup = ReplicationConnectionGroupManager.getConnectionGroupInstance(group);
                if (this.enableJMX) {
                    ReplicationConnectionGroupManager.registerJmx();
                }
                this.connectionGroupID = this.connectionGroup.registerReplicationConnection(this.thisAsReplicationConnection, ((ReplicationConnectionUrl)connectionUrl).getSourcesListAsHostPortPairs(), ((ReplicationConnectionUrl)connectionUrl).getReplicasListAsHostPortPairs());
                this.sourceHosts = ((ReplicationConnectionUrl)connectionUrl).getSourceHostsListFromHostPortPairs(this.connectionGroup.getSourceHosts());
                this.replicaHosts = ((ReplicationConnectionUrl)connectionUrl).getReplicaHostsListFromHostPortPairs(this.connectionGroup.getReplicaHosts());
            } else {
                this.sourceHosts = new ArrayList<HostInfo>(connectionUrl.getHostsList(HostsListView.SOURCES));
                this.replicaHosts = new ArrayList<HostInfo>(connectionUrl.getHostsList(HostsListView.REPLICAS));
            }
            this.resetReadFromSourceWhenNoReplicas();
            try {
                this.initializeReplicasConnection();
            }
            catch (SQLException e) {
                if (this.allowReplicaDownConnections) break block21;
                if (this.connectionGroup != null) {
                    this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
                }
                throw e;
            }
        }
        SQLException exCaught = null;
        try {
            this.currentConnection = this.initializeSourceConnection();
        }
        catch (SQLException e) {
            exCaught = e;
        }
        if (this.currentConnection == null) {
            if (this.allowSourceDownConnections && this.replicasConnection != null) {
                this.readOnly = true;
                this.currentConnection = this.replicasConnection;
            } else {
                if (this.connectionGroup != null) {
                    this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
                }
                if (exCaught != null) {
                    throw exCaught;
                }
                throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.initializationWithEmptyHostsLists"), "S1009", null);
            }
        }
    }

    @Override
    JdbcConnection getNewWrapperForThisAsConnection() throws SQLException {
        return new ReplicationMySQLConnection(this);
    }

    @Override
    protected void propagateProxyDown(JdbcConnection proxyConn) {
        if (this.sourceConnection != null) {
            this.sourceConnection.setProxy(proxyConn);
        }
        if (this.replicasConnection != null) {
            this.replicasConnection.setProxy(proxyConn);
        }
    }

    @Override
    boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        return false;
    }

    @Override
    public boolean isSourceConnection() {
        return this.currentConnection != null && this.currentConnection == this.sourceConnection;
    }

    public boolean isReplicasConnection() {
        return this.currentConnection != null && this.currentConnection == this.replicasConnection;
    }

    @Override
    void pickNewConnection() throws SQLException {
    }

    @Override
    void syncSessionState(JdbcConnection source, JdbcConnection target, boolean readonly) throws SQLException {
        try {
            super.syncSessionState(source, target, readonly);
        }
        catch (SQLException e1) {
            try {
                super.syncSessionState(source, target, readonly);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    void doClose() throws SQLException {
        if (this.sourceConnection != null) {
            this.sourceConnection.close();
        }
        if (this.replicasConnection != null) {
            this.replicasConnection.close();
        }
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
        }
    }

    @Override
    void doAbortInternal() throws SQLException {
        this.sourceConnection.abortInternal();
        this.replicasConnection.abortInternal();
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
        }
    }

    @Override
    void doAbort(Executor executor) throws SQLException {
        this.sourceConnection.abort(executor);
        this.replicasConnection.abort(executor);
        if (this.connectionGroup != null) {
            this.connectionGroup.handleCloseConnection(this.thisAsReplicationConnection);
        }
    }

    @Override
    Object invokeMore(Object proxy, Method method, Object[] args) throws Throwable {
        this.checkConnectionCapabilityForMethod(method);
        boolean invokeAgain = false;
        while (true) {
            try {
                Object result = method.invoke((Object)this.thisAsConnection, args);
                if (result != null && result instanceof JdbcStatement) {
                    ((JdbcStatement)result).setPingTarget(this);
                }
                return result;
            }
            catch (InvocationTargetException e) {
                if (invokeAgain) {
                    invokeAgain = false;
                    continue;
                }
                if (e.getCause() == null || !(e.getCause() instanceof SQLException) || ((SQLException)e.getCause()).getSQLState() != "25000" || ((SQLException)e.getCause()).getErrorCode() != 1000001) continue;
                try {
                    this.setReadOnly(this.readOnly);
                    invokeAgain = true;
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (invokeAgain) continue;
                throw e;
            }
            break;
        }
    }

    private void checkConnectionCapabilityForMethod(Method method) throws Throwable {
        if (this.sourceHosts.isEmpty() && this.replicaHosts.isEmpty() && !ReplicationConnection.class.isAssignableFrom(method.getDeclaringClass())) {
            throw SQLError.createSQLException(Messages.getString("ReplicationConnectionProxy.noHostsInconsistentState"), "25000", 1000002, true, null);
        }
    }

    @Override
    public void doPing() throws SQLException {
        SQLException replicasPingException;
        SQLException sourcesPingException;
        boolean isSourceConn;
        block16: {
            isSourceConn = this.isSourceConnection();
            sourcesPingException = null;
            replicasPingException = null;
            if (this.sourceConnection != null) {
                try {
                    this.sourceConnection.ping();
                }
                catch (SQLException e) {
                    sourcesPingException = e;
                }
            } else {
                this.initializeSourceConnection();
            }
            if (this.replicasConnection != null) {
                try {
                    this.replicasConnection.ping();
                }
                catch (SQLException e) {
                    replicasPingException = e;
                }
            } else {
                try {
                    this.initializeReplicasConnection();
                    if (this.switchToReplicasConnectionIfNecessary()) {
                        isSourceConn = false;
                    }
                }
                catch (SQLException e) {
                    if (this.sourceConnection != null && this.readFromSourceWhenNoReplicas) break block16;
                    throw e;
                }
            }
        }
        if (isSourceConn && sourcesPingException != null) {
            if (this.replicasConnection != null && replicasPingException == null) {
                this.sourceConnection = null;
                this.currentConnection = this.replicasConnection;
                this.readOnly = true;
            }
            throw sourcesPingException;
        }
        if (!(isSourceConn || replicasPingException == null && this.replicasConnection != null)) {
            if (this.sourceConnection != null && this.readFromSourceWhenNoReplicas && sourcesPingException == null) {
                this.replicasConnection = null;
                this.currentConnection = this.sourceConnection;
                this.readOnly = true;
                this.currentConnection.setReadOnly(true);
            }
            if (replicasPingException != null) {
                throw replicasPingException;
            }
        }
    }

    private JdbcConnection initializeSourceConnection() throws SQLException {
        this.sourceConnection = null;
        if (this.sourceHosts.size() == 0) {
            return null;
        }
        LoadBalancedConnection newSourceConn = LoadBalancedConnectionProxy.createProxyInstance(new LoadBalanceConnectionUrl(this.sourceHosts, this.connectionUrl.getOriginalProperties()));
        newSourceConn.setProxy(this.getProxy());
        this.sourceConnection = newSourceConn;
        return this.sourceConnection;
    }

    private JdbcConnection initializeReplicasConnection() throws SQLException {
        this.replicasConnection = null;
        if (this.replicaHosts.size() == 0) {
            return null;
        }
        LoadBalancedConnection newReplicasConn = LoadBalancedConnectionProxy.createProxyInstance(new LoadBalanceConnectionUrl(this.replicaHosts, this.connectionUrl.getOriginalProperties()));
        newReplicasConn.setProxy(this.getProxy());
        newReplicasConn.setReadOnly(true);
        this.replicasConnection = newReplicasConn;
        return this.replicasConnection;
    }

    private boolean switchToSourceConnection() throws SQLException {
        this.getLock().lock();
        try {
            if (this.sourceConnection == null || this.sourceConnection.isClosed()) {
                try {
                    if (this.initializeSourceConnection() == null) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (SQLException e) {
                    this.currentConnection = null;
                    throw e;
                }
            }
            if (!this.isSourceConnection() && this.sourceConnection != null) {
                this.syncSessionState(this.currentConnection, this.sourceConnection, false);
                this.currentConnection = this.sourceConnection;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.getLock().unlock();
        }
    }

    private boolean switchToReplicasConnection() throws SQLException {
        this.getLock().lock();
        try {
            if (this.replicasConnection == null || this.replicasConnection.isClosed()) {
                try {
                    if (this.initializeReplicasConnection() == null) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (SQLException e) {
                    this.currentConnection = null;
                    throw e;
                }
            }
            if (!this.isReplicasConnection() && this.replicasConnection != null) {
                this.syncSessionState(this.currentConnection, this.replicasConnection, true);
                this.currentConnection = this.replicasConnection;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.getLock().unlock();
        }
    }

    private boolean switchToReplicasConnectionIfNecessary() throws SQLException {
        if (this.currentConnection == null || this.isSourceConnection() && (this.readOnly || this.sourceHosts.isEmpty() && this.currentConnection.isClosed()) || !this.isSourceConnection() && this.currentConnection.isClosed()) {
            return this.switchToReplicasConnection();
        }
        return false;
    }

    public JdbcConnection getCurrentConnection() {
        this.getLock().lock();
        try {
            JdbcConnection jdbcConnection = this.currentConnection == null ? LoadBalancedConnectionProxy.getNullLoadBalancedConnectionInstance() : this.currentConnection;
            return jdbcConnection;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public long getConnectionGroupId() {
        return this.connectionGroupID;
    }

    public JdbcConnection getSourceConnection() {
        this.getLock().lock();
        try {
            LoadBalancedConnection loadBalancedConnection = this.sourceConnection;
            return loadBalancedConnection;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void promoteReplicaToSource(String hostPortPair) throws SQLException {
        this.getLock().lock();
        try {
            HostInfo host = this.getReplicaHost(hostPortPair);
            if (host == null) {
                return;
            }
            this.sourceHosts.add(host);
            this.removeReplica(hostPortPair);
            if (this.sourceConnection != null) {
                this.sourceConnection.addHost(hostPortPair);
            }
            if (!this.readOnly && !this.isSourceConnection()) {
                this.switchToSourceConnection();
            }
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void removeSourceHost(String hostPortPair) throws SQLException {
        this.getLock().lock();
        try {
            this.removeSourceHost(hostPortPair, true);
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void removeSourceHost(String hostPortPair, boolean waitUntilNotInUse) throws SQLException {
        this.getLock().lock();
        try {
            this.removeSourceHost(hostPortPair, waitUntilNotInUse, false);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceHost(String hostPortPair, boolean waitUntilNotInUse, boolean isNowReplica) throws SQLException {
        this.getLock().lock();
        try {
            HostInfo host = this.getSourceHost(hostPortPair);
            if (host == null) {
                return;
            }
            if (isNowReplica) {
                this.replicaHosts.add(host);
                this.resetReadFromSourceWhenNoReplicas();
            }
            this.sourceHosts.remove(host);
            if (this.sourceConnection == null || this.sourceConnection.isClosed()) {
                this.sourceConnection = null;
                return;
            }
            if (waitUntilNotInUse) {
                this.sourceConnection.removeHostWhenNotInUse(hostPortPair);
            } else {
                this.sourceConnection.removeHost(hostPortPair);
            }
            if (this.sourceHosts.isEmpty()) {
                this.sourceConnection.close();
                this.sourceConnection = null;
                this.switchToReplicasConnectionIfNecessary();
            }
        }
        finally {
            this.getLock().unlock();
        }
    }

    public boolean isHostSource(String hostPortPair) {
        if (hostPortPair == null) {
            return false;
        }
        return this.sourceHosts.stream().anyMatch(hi -> hostPortPair.equalsIgnoreCase(hi.getHostPortPair()));
    }

    public JdbcConnection getReplicasConnection() {
        this.getLock().lock();
        try {
            LoadBalancedConnection loadBalancedConnection = this.replicasConnection;
            return loadBalancedConnection;
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void addReplicaHost(String hostPortPair) throws SQLException {
        this.getLock().lock();
        try {
            if (this.isHostReplica(hostPortPair)) {
                return;
            }
            this.replicaHosts.add(this.getConnectionUrl().getReplicaHostOrSpawnIsolated(hostPortPair));
            this.resetReadFromSourceWhenNoReplicas();
            if (this.replicasConnection == null) {
                this.initializeReplicasConnection();
                this.switchToReplicasConnectionIfNecessary();
            } else {
                this.replicasConnection.addHost(hostPortPair);
            }
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void removeReplica(String hostPortPair) throws SQLException {
        this.getLock().lock();
        try {
            this.removeReplica(hostPortPair, true);
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReplica(String hostPortPair, boolean closeGently) throws SQLException {
        this.getLock().lock();
        try {
            HostInfo host = this.getReplicaHost(hostPortPair);
            if (host == null) {
                return;
            }
            this.replicaHosts.remove(host);
            this.resetReadFromSourceWhenNoReplicas();
            if (this.replicasConnection == null || this.replicasConnection.isClosed()) {
                this.replicasConnection = null;
                return;
            }
            if (closeGently) {
                this.replicasConnection.removeHostWhenNotInUse(hostPortPair);
            } else {
                this.replicasConnection.removeHost(hostPortPair);
            }
            if (this.replicaHosts.isEmpty()) {
                this.replicasConnection.close();
                this.replicasConnection = null;
                this.switchToSourceConnection();
                if (this.isSourceConnection()) {
                    this.currentConnection.setReadOnly(this.readOnly);
                }
            }
        }
        finally {
            this.getLock().unlock();
        }
    }

    public boolean isHostReplica(String hostPortPair) {
        if (hostPortPair == null) {
            return false;
        }
        return this.replicaHosts.stream().anyMatch(hi -> hostPortPair.equalsIgnoreCase(hi.getHostPortPair()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getLock().lock();
        try {
            if (readOnly) {
                if (!this.isReplicasConnection() || this.currentConnection.isClosed()) {
                    boolean switched = true;
                    SQLException exceptionCaught = null;
                    try {
                        switched = this.switchToReplicasConnection();
                    }
                    catch (SQLException e) {
                        switched = false;
                        exceptionCaught = e;
                    }
                    if (!switched && this.readFromSourceWhenNoReplicas && this.switchToSourceConnection()) {
                        exceptionCaught = null;
                    }
                    if (exceptionCaught != null) {
                        throw exceptionCaught;
                    }
                }
            } else if (!this.isSourceConnection() || this.currentConnection.isClosed()) {
                boolean switched = true;
                SQLException exceptionCaught = null;
                try {
                    switched = this.switchToSourceConnection();
                }
                catch (SQLException e) {
                    switched = false;
                    exceptionCaught = e;
                }
                if (!switched && this.switchToReplicasConnectionIfNecessary()) {
                    exceptionCaught = null;
                }
                if (exceptionCaught != null) {
                    throw exceptionCaught;
                }
            }
            this.readOnly = readOnly;
            if (this.readFromSourceWhenNoReplicas && this.isSourceConnection()) {
                this.currentConnection.setReadOnly(this.readOnly);
            }
        }
        finally {
            this.getLock().unlock();
        }
    }

    public boolean isReadOnly() throws SQLException {
        return !this.isSourceConnection() || this.readOnly;
    }

    private void resetReadFromSourceWhenNoReplicas() {
        this.readFromSourceWhenNoReplicas = this.replicaHosts.isEmpty() || this.readFromSourceWhenNoReplicasOriginal;
    }

    private HostInfo getSourceHost(String hostPortPair) {
        return this.sourceHosts.stream().filter(hi -> hostPortPair.equalsIgnoreCase(hi.getHostPortPair())).findFirst().orElse(null);
    }

    private HostInfo getReplicaHost(String hostPortPair) {
        return this.replicaHosts.stream().filter(hi -> hostPortPair.equalsIgnoreCase(hi.getHostPortPair())).findFirst().orElse(null);
    }

    private ReplicationConnectionUrl getConnectionUrl() {
        return (ReplicationConnectionUrl)this.connectionUrl;
    }
}

