/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mysql.cj.protocol.a.authentication;

import com.oracle.bmc.ConfigFileReader;
import dev.brighten.antivpn.shaded.com.mysql.cj.Messages;
import dev.brighten.antivpn.shaded.com.mysql.cj.callback.MysqlCallbackHandler;
import dev.brighten.antivpn.shaded.com.mysql.cj.callback.UsernameCallback;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.PropertyKey;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.ExceptionFactory;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.RSAException;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.AuthenticationPlugin;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.ExportControlled;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.Protocol;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.a.NativeConstants;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.a.NativePacketPayload;
import dev.brighten.antivpn.shaded.com.mysql.cj.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.interfaces.RSAPrivateKey;
import java.util.Base64;
import java.util.List;

public class AuthenticationOciClient
implements AuthenticationPlugin<NativePacketPayload> {
    public static String PLUGIN_NAME = "authentication_oci_client";
    private String sourceOfAuthData = PLUGIN_NAME;
    protected Protocol<NativePacketPayload> protocol = null;
    private MysqlCallbackHandler usernameCallbackHandler = null;
    private String configFingerprint = null;
    private String configKeyFile = null;
    private String configSecurityTokenFile = null;
    private RSAPrivateKey privateKey = null;
    private byte[] token = null;

    @Override
    public void init(Protocol<NativePacketPayload> prot, MysqlCallbackHandler cbh) {
        this.protocol = prot;
        this.usernameCallbackHandler = cbh;
    }

    @Override
    public void reset() {
        this.configFingerprint = null;
        this.privateKey = null;
    }

    @Override
    public void destroy() {
        this.reset();
        this.protocol = null;
        this.usernameCallbackHandler = null;
    }

    @Override
    public String getProtocolPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return false;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        if (user == null && this.usernameCallbackHandler != null) {
            this.usernameCallbackHandler.handle(new UsernameCallback(System.getProperty("user.name")));
        }
    }

    @Override
    public void setSourceOfAuthData(String sourceOfAuthData) {
        this.sourceOfAuthData = sourceOfAuthData;
    }

    @Override
    public boolean nextAuthenticationStep(NativePacketPayload fromServer, List<NativePacketPayload> toServer) {
        toServer.clear();
        if (!this.sourceOfAuthData.equals(PLUGIN_NAME) || fromServer.getPayloadLength() == 0) {
            toServer.add(new NativePacketPayload(0));
            return true;
        }
        this.loadOciConfig();
        this.initializePrivateKey();
        this.initializeToken();
        byte[] nonce = fromServer.readBytes(NativeConstants.StringSelfDataType.STRING_EOF);
        byte[] signature = ExportControlled.sign(nonce, this.privateKey);
        if (signature == null) {
            signature = new byte[]{};
        }
        String payload = String.format("{\"fingerprint\":\"%s\", \"signature\":\"%s\", \"token\":\"%s\"}", this.configFingerprint, Base64.getEncoder().encodeToString(signature), new String(this.token));
        toServer.add(new NativePacketPayload(payload.getBytes(Charset.defaultCharset())));
        return true;
    }

    private void loadOciConfig() {
        ConfigFileReader.ConfigFile configFile;
        block8: {
            try {
                String configFilePath = this.protocol.getPropertySet().getStringProperty(PropertyKey.ociConfigFile.getKeyName()).getStringValue();
                String configProfile = this.protocol.getPropertySet().getStringProperty(PropertyKey.ociConfigProfile.getKeyName()).getStringValue();
                if (StringUtils.isNullOrEmpty(configFilePath)) {
                    configFile = ConfigFileReader.parseDefault((String)configProfile);
                    break block8;
                }
                if (Files.exists(Paths.get(configFilePath, new String[0]), new LinkOption[0])) {
                    configFile = ConfigFileReader.parse((String)configFilePath, (String)configProfile);
                    break block8;
                }
                throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.ConfigFileNotFound"));
            }
            catch (NoClassDefFoundError e) {
                throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.OciSdkNotFound"), e);
            }
            catch (IOException e) {
                throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.OciConfigFileError"), e);
            }
            catch (IllegalArgumentException e) {
                throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.ProfileNotFound"), e);
            }
        }
        this.configFingerprint = configFile.get("fingerprint");
        if (StringUtils.isNullOrEmpty(this.configFingerprint)) {
            throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.OciConfigFileMissingEntry"));
        }
        this.configKeyFile = configFile.get("key_file");
        if (StringUtils.isNullOrEmpty(this.configKeyFile)) {
            throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.OciConfigFileMissingEntry"));
        }
        this.configSecurityTokenFile = configFile.get("security_token_file");
    }

    private void initializePrivateKey() {
        if (this.privateKey != null) {
            return;
        }
        try {
            Path keyFilePath = Paths.get(this.configKeyFile, new String[0]);
            if (Files.notExists(keyFilePath, new LinkOption[0])) {
                throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.PrivateKeyNotFound"));
            }
            String key = new String(Files.readAllBytes(keyFilePath));
            this.privateKey = ExportControlled.decodeRSAPrivateKey(key);
        }
        catch (IOException e) {
            throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.FailedReadingPrivateKey"), e);
        }
        catch (RSAException | IllegalArgumentException e) {
            throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.PrivateKeyNotValid"), e);
        }
    }

    private void initializeToken() {
        if (this.token != null) {
            return;
        }
        if (StringUtils.isNullOrEmpty(this.configSecurityTokenFile)) {
            this.token = new byte[0];
            return;
        }
        try {
            Path securityTokenFilePath = Paths.get(this.configSecurityTokenFile, new String[0]);
            if (Files.notExists(securityTokenFilePath, new LinkOption[0])) {
                throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.SecurityTokenFileNotFound"));
            }
            long size = Files.size(securityTokenFilePath);
            if (size > 10240L) {
                throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.SecurityTokenTooBig"));
            }
            this.token = Files.readAllBytes(Paths.get(this.configSecurityTokenFile, new String[0]));
        }
        catch (IOException e) {
            throw ExceptionFactory.createException(Messages.getString("AuthenticationOciClientPlugin.FailedReadingSecurityTokenFile"), e);
        }
    }
}

