/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.com.mysql.cj.result;

import dev.brighten.antivpn.shaded.com.mysql.cj.Messages;
import dev.brighten.antivpn.shaded.com.mysql.cj.WarningListener;
import dev.brighten.antivpn.shaded.com.mysql.cj.conf.PropertySet;
import dev.brighten.antivpn.shaded.com.mysql.cj.exceptions.DataReadException;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.InternalDate;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.InternalTime;
import dev.brighten.antivpn.shaded.com.mysql.cj.protocol.InternalTimestamp;
import dev.brighten.antivpn.shaded.com.mysql.cj.result.AbstractDateTimeValueFactory;
import java.time.LocalTime;

public class LocalTimeValueFactory
extends AbstractDateTimeValueFactory<LocalTime> {
    private WarningListener warningListener;

    public LocalTimeValueFactory(PropertySet pset) {
        super(pset);
    }

    public LocalTimeValueFactory(PropertySet pset, WarningListener warningListener) {
        this(pset);
        this.warningListener = warningListener;
    }

    @Override
    LocalTime localCreateFromDate(InternalDate idate) {
        return LocalTime.of(0, 0);
    }

    @Override
    public LocalTime localCreateFromTime(InternalTime it) {
        if (it.getHours() < 0 || it.getHours() >= 24) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidTimeValue", new Object[]{it.toString()}));
        }
        return LocalTime.of(it.getHours(), it.getMinutes(), it.getSeconds(), it.getNanos());
    }

    @Override
    public LocalTime localCreateFromTimestamp(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalTime)this.createFromTime(new InternalTime(its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos(), its.getScale()));
    }

    @Override
    public LocalTime localCreateFromDatetime(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalTime)this.createFromTime(new InternalTime(its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos(), its.getScale()));
    }

    @Override
    public String getTargetTypeName() {
        return LocalTime.class.getName();
    }
}

