/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.org.bson;

import dev.brighten.antivpn.shaded.org.bson.BsonBinaryReader;
import dev.brighten.antivpn.shaded.org.bson.BsonType;
import dev.brighten.antivpn.shaded.org.bson.BsonValue;
import dev.brighten.antivpn.shaded.org.bson.RawBsonArray;
import dev.brighten.antivpn.shaded.org.bson.RawBsonDocument;
import dev.brighten.antivpn.shaded.org.bson.codecs.BsonValueCodecProvider;
import dev.brighten.antivpn.shaded.org.bson.codecs.DecoderContext;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecRegistries;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecRegistry;
import dev.brighten.antivpn.shaded.org.bson.io.BsonInputMark;

final class RawBsonValueHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());

    static BsonValue decode(byte[] bytes, BsonBinaryReader bsonReader) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT || bsonReader.getCurrentBsonType() == BsonType.ARRAY) {
            int position = bsonReader.getBsonInput().getPosition();
            BsonInputMark mark = bsonReader.getBsonInput().getMark(4);
            int size = bsonReader.getBsonInput().readInt32();
            mark.reset();
            bsonReader.skipValue();
            if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new RawBsonDocument(bytes, position, size);
            }
            return new RawBsonArray(bytes, position, size);
        }
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    private RawBsonValueHelper() {
    }
}

