/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.org.bson.codecs;

import dev.brighten.antivpn.shaded.org.bson.BsonDocument;
import dev.brighten.antivpn.shaded.org.bson.BsonElement;
import dev.brighten.antivpn.shaded.org.bson.BsonObjectId;
import dev.brighten.antivpn.shaded.org.bson.BsonReader;
import dev.brighten.antivpn.shaded.org.bson.BsonType;
import dev.brighten.antivpn.shaded.org.bson.BsonValue;
import dev.brighten.antivpn.shaded.org.bson.BsonWriter;
import dev.brighten.antivpn.shaded.org.bson.codecs.BsonTypeCodecMap;
import dev.brighten.antivpn.shaded.org.bson.codecs.BsonValueCodecProvider;
import dev.brighten.antivpn.shaded.org.bson.codecs.Codec;
import dev.brighten.antivpn.shaded.org.bson.codecs.CollectibleCodec;
import dev.brighten.antivpn.shaded.org.bson.codecs.DecoderContext;
import dev.brighten.antivpn.shaded.org.bson.codecs.EncoderContext;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecRegistries;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecRegistry;
import dev.brighten.antivpn.shaded.org.bson.types.ObjectId;
import java.util.ArrayList;
import java.util.Map;

public class BsonDocumentCodec
implements CollectibleCodec<BsonDocument> {
    private static final String ID_FIELD_NAME = "_id";
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final CodecRegistry codecRegistry;
    private final BsonTypeCodecMap bsonTypeCodecMap;

    public BsonDocumentCodec() {
        this(DEFAULT_REGISTRY);
    }

    public BsonDocumentCodec(CodecRegistry codecRegistry) {
        if (codecRegistry == null) {
            throw new IllegalArgumentException("Codec registry can not be null");
        }
        this.codecRegistry = codecRegistry;
        this.bsonTypeCodecMap = new BsonTypeCodecMap(BsonValueCodecProvider.getBsonTypeClassMap(), codecRegistry);
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public BsonDocument decode(BsonReader reader, DecoderContext decoderContext) {
        ArrayList<BsonElement> keyValuePairs = new ArrayList<BsonElement>();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            keyValuePairs.add(new BsonElement(fieldName, this.readValue(reader, decoderContext)));
        }
        reader.readEndDocument();
        return new BsonDocument(keyValuePairs);
    }

    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        return (BsonValue)this.bsonTypeCodecMap.get(reader.getCurrentBsonType()).decode(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, BsonDocument value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.beforeFields(writer, encoderContext, value);
        for (Map.Entry<String, BsonValue> entry : value.entrySet()) {
            if (this.skipField(encoderContext, entry.getKey())) continue;
            writer.writeName(entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, BsonDocument value) {
        if (encoderContext.isEncodingCollectibleDocument() && value.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, value.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, BsonValue value) {
        Codec<?> codec = this.codecRegistry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }

    @Override
    public Class<BsonDocument> getEncoderClass() {
        return BsonDocument.class;
    }

    @Override
    public BsonDocument generateIdIfAbsentFromDocument(BsonDocument document) {
        if (!this.documentHasId(document)) {
            document.put(ID_FIELD_NAME, new BsonObjectId(new ObjectId()));
        }
        return document;
    }

    @Override
    public boolean documentHasId(BsonDocument document) {
        return document.containsKey(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(BsonDocument document) {
        return document.get(ID_FIELD_NAME);
    }
}

