/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.org.bson.codecs;

import dev.brighten.antivpn.shaded.org.bson.Document;
import dev.brighten.antivpn.shaded.org.bson.Transformer;
import dev.brighten.antivpn.shaded.org.bson.assertions.Assertions;
import dev.brighten.antivpn.shaded.org.bson.codecs.BsonTypeClassMap;
import dev.brighten.antivpn.shaded.org.bson.codecs.CodeWithScopeCodec;
import dev.brighten.antivpn.shaded.org.bson.codecs.Codec;
import dev.brighten.antivpn.shaded.org.bson.codecs.DocumentCodec;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecProvider;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecRegistry;
import dev.brighten.antivpn.shaded.org.bson.types.CodeWithScope;

public class DocumentCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;
    private final Transformer valueTransformer;

    public DocumentCodecProvider() {
        this(new BsonTypeClassMap());
    }

    public DocumentCodecProvider(Transformer valueTransformer) {
        this(new BsonTypeClassMap(), valueTransformer);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this(bsonTypeClassMap, null);
    }

    public DocumentCodecProvider(BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.bsonTypeClassMap = Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap);
        this.valueTransformer = valueTransformer;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == CodeWithScope.class) {
            return new CodeWithScopeCodec(registry.get(Document.class));
        }
        if (clazz == Document.class) {
            return new DocumentCodec(registry, this.bsonTypeClassMap, this.valueTransformer);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentCodecProvider that = (DocumentCodecProvider)o;
        if (!this.bsonTypeClassMap.equals(that.bsonTypeClassMap)) {
            return false;
        }
        return !(this.valueTransformer != null ? !this.valueTransformer.equals(that.valueTransformer) : that.valueTransformer != null);
    }

    public int hashCode() {
        int result = this.bsonTypeClassMap.hashCode();
        result = 31 * result + (this.valueTransformer != null ? this.valueTransformer.hashCode() : 0);
        return result;
    }
}

