/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.org.bson.codecs.jsr310;

import dev.brighten.antivpn.shaded.org.bson.BsonReader;
import dev.brighten.antivpn.shaded.org.bson.BsonWriter;
import dev.brighten.antivpn.shaded.org.bson.codecs.DecoderContext;
import dev.brighten.antivpn.shaded.org.bson.codecs.EncoderContext;
import dev.brighten.antivpn.shaded.org.bson.codecs.configuration.CodecConfigurationException;
import dev.brighten.antivpn.shaded.org.bson.codecs.jsr310.DateTimeBasedCodec;
import java.time.Instant;

public class InstantCodec
extends DateTimeBasedCodec<Instant> {
    @Override
    public Instant decode(BsonReader reader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(reader));
    }

    @Override
    public void encode(BsonWriter writer, Instant value, EncoderContext encoderContext) {
        try {
            writer.writeDateTime(value.toEpochMilli());
        }
        catch (ArithmeticException e) {
            throw new CodecConfigurationException(String.format("Unsupported Instant value '%s' could not be converted to milliseconds: %s", value, e.getMessage()), e);
        }
    }

    @Override
    public Class<Instant> getEncoderClass() {
        return Instant.class;
    }
}

