/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.org.h2.expression;

import dev.brighten.antivpn.shaded.org.h2.command.Prepared;
import dev.brighten.antivpn.shaded.org.h2.engine.SessionLocal;
import dev.brighten.antivpn.shaded.org.h2.expression.Expression;
import dev.brighten.antivpn.shaded.org.h2.expression.ExpressionVisitor;
import dev.brighten.antivpn.shaded.org.h2.expression.Operation0;
import dev.brighten.antivpn.shaded.org.h2.expression.ValueExpression;
import dev.brighten.antivpn.shaded.org.h2.message.DbException;
import dev.brighten.antivpn.shaded.org.h2.value.TypeInfo;
import dev.brighten.antivpn.shaded.org.h2.value.Value;
import dev.brighten.antivpn.shaded.org.h2.value.ValueBigint;

public final class Rownum
extends Operation0 {
    private final Prepared prepared;
    private boolean singleRow;

    public Rownum(Prepared prepared) {
        if (prepared == null) {
            throw DbException.getInternalError();
        }
        this.prepared = prepared;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        return ValueBigint.get(this.prepared.getCurrentRowNumber());
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_BIGINT;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, int n) {
        return stringBuilder.append("ROWNUM()");
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        return this.singleRow ? ValueExpression.get(ValueBigint.get(1L)) : this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return false;
            }
            case 11: {
                if (expressionVisitor.getQueryLevel() <= 0) break;
                this.singleRow = true;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

