/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.sponge;

import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.PlayerExecutor;
import dev.brighten.antivpn.shaded.com.github.benmanes.caffeine.cache.Cache;
import dev.brighten.antivpn.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import dev.brighten.antivpn.sponge.SpongePlayer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;

public class SpongePlayerExecutor
implements PlayerExecutor {
    private final Cache<UUID, SpongePlayer> playerCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();

    @Override
    public Optional<APIPlayer> getPlayer(String name) {
        Optional serverPlayer = Sponge.server().player(name);
        return serverPlayer.map(SpongePlayer::new);
    }

    @Override
    public Optional<APIPlayer> getPlayer(UUID uuid) {
        SpongePlayer cachedPlayer = this.playerCache.getIfPresent(uuid);
        if (cachedPlayer != null) {
            return Optional.of(cachedPlayer);
        }
        Optional serverPlayer = Sponge.server().player(uuid);
        Optional<APIPlayer> player = serverPlayer.map(SpongePlayer::new);
        player.ifPresent(value -> this.playerCache.put(uuid, (SpongePlayer)value));
        return player;
    }

    @Override
    public void unloadPlayer(UUID uuid) {
        this.playerCache.invalidate(uuid);
    }

    @Override
    public List<APIPlayer> getOnlinePlayers() {
        if (!Sponge.game().isServerAvailable()) {
            return Collections.emptyList();
        }
        return Sponge.server().onlinePlayers().stream().map(pl -> {
            SpongePlayer cachedPlayer = this.playerCache.getIfPresent(pl.uniqueId());
            if (cachedPlayer != null) {
                return cachedPlayer;
            }
            SpongePlayer player = new SpongePlayer((ServerPlayer)pl);
            this.playerCache.put(pl.uniqueId(), player);
            return player;
        }).toList();
    }
}

