/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.sponge.command;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.command.Command;
import dev.brighten.antivpn.sponge.command.SpongeCommandExecutor;
import dev.brighten.antivpn.utils.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.parameter.ArgumentReader;

public class SpongeCommand
implements Command.Raw {
    private final Command command;

    public SpongeCommand(Command command) {
        this.command = command;
    }

    public CommandResult process(CommandCause sender, ArgumentReader.Mutable arguments) {
        String[] args = arguments.input().split(" ");
        SpongeCommandExecutor commandExecutor = new SpongeCommandExecutor(sender);
        Command[] children = this.command.children();
        if (children.length > 0 && args.length > 0) {
            for (Command child : children) {
                if (!child.name().equalsIgnoreCase(args[0]) && !Arrays.stream(child.aliases()).anyMatch(alias -> alias.equalsIgnoreCase(args[0]))) continue;
                if (!sender.hasPermission("antivpn.command.*") && !sender.hasPermission(child.permission())) {
                    return CommandResult.error((Component)Component.text((String)StringUtil.translateAlternateColorCodes('&', AntiVPN.getInstance().getMessageHandler().getString("no-permission").getMessage())));
                }
                commandExecutor.sendMessage(StringUtil.translateAlternateColorCodes('&', child.execute(commandExecutor, (String[])IntStream.range(0, args.length - 1).mapToObj(i -> args[i + 1]).toArray(String[]::new))), new Object[0]);
                return CommandResult.success();
            }
        }
        commandExecutor.sendMessage(StringUtil.translateAlternateColorCodes('&', this.command.execute(new SpongeCommandExecutor(sender), args)), new Object[0]);
        this.command.execute(new SpongeCommandExecutor(sender), args);
        return CommandResult.success();
    }

    public List<CommandCompletion> complete(CommandCause sender, ArgumentReader.Mutable arguments) {
        Command[] children = this.command.children();
        String[] args = arguments.input().split(" ");
        if (children.length > 0 && args.length > 0) {
            for (Command child : children) {
                if (!child.name().equalsIgnoreCase(args[0]) && !Arrays.stream(child.aliases()).anyMatch(alias2 -> alias2.equalsIgnoreCase(args[0]))) continue;
                return child.tabComplete(new SpongeCommandExecutor(sender), "alias", (String[])IntStream.range(0, args.length - 1).mapToObj(i -> args[i + 1]).toArray(String[]::new)).stream().map(CommandCompletion::of).toList();
            }
        }
        return this.command.tabComplete(new SpongeCommandExecutor(sender), "alias", args).stream().map(CommandCompletion::of).toList();
    }

    public boolean canExecute(CommandCause cause) {
        return cause.hasPermission(this.command.permission());
    }

    public Optional<Component> shortDescription(CommandCause cause) {
        return this.command.description() != null ? Optional.of(Component.text((String)this.command.description())) : Optional.empty();
    }

    public Optional<Component> extendedDescription(CommandCause cause) {
        return Optional.empty();
    }

    public Optional<Component> help(@NonNull CommandCause cause) {
        return Optional.of(Component.text((String)StringUtil.translateAlternateColorCodes('&', this.command.execute(new SpongeCommandExecutor(cause), new String[0]))));
    }

    public Component usage(CommandCause cause) {
        return this.command.usage() != null ? Component.text((String)this.command.usage()) : Component.empty();
    }
}

