/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.utils.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class Configuration {
    private static final char SEPARATOR = '.';
    final Map<String, Object> self = new LinkedHashMap<String, Object>();
    final Map<String, List<String>> comments;
    private final Configuration defaults;

    public Configuration() {
        this(null);
    }

    public Configuration(Configuration defaults) {
        this(new LinkedHashMap(), defaults);
    }

    Configuration(Map<?, ?> map, Configuration defaults) {
        this.defaults = defaults;
        this.comments = new HashMap<String, List<String>>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key;
            String string = key = entry.getKey() == null ? "null" : entry.getKey().toString();
            if (entry.getValue() instanceof Map) {
                this.self.put(key, new Configuration((Map)entry.getValue(), defaults == null ? null : defaults.getSection(key)));
                continue;
            }
            this.self.put(key, entry.getValue());
        }
    }

    public void loadFromString(String contents) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, contents.split("\n"));
        int currentLayer = 0;
        Object currentPath = "";
        int lineNumber = 0;
        for (String line : list) {
            String trimmed = line.trim();
            if (trimmed.startsWith("#") || trimmed.isEmpty()) {
                this.addCommentLine((String)currentPath, line);
            } else if (!line.isEmpty() && line.contains(":")) {
                int layerFromLine = this.getLayerFromLine(line, lineNumber);
                if (layerFromLine < currentLayer) {
                    currentPath = this.regressPathBy(currentLayer - layerFromLine, (String)currentPath);
                }
                String key = this.getKeyFromLine(line);
                currentPath = currentLayer == 0 ? key : (String)currentPath + "." + key;
            }
            ++lineNumber;
        }
    }

    private void addCommentLine(String currentPath, String line) {
        List<String> list = this.comments.get(currentPath);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(line);
        this.comments.put(currentPath, list);
    }

    String getKeyFromLine(String line) {
        String key = null;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != ':') continue;
            key = line.substring(0, i);
            break;
        }
        return key == null ? null : key.trim();
    }

    String regressPathBy(int i, String currentPath) {
        if (i <= 0) {
            return currentPath;
        }
        String[] split = currentPath.split("\\.");
        Object rebuild = "";
        for (int j = 0; j < split.length - i; ++j) {
            rebuild = (String)rebuild + split[j];
            if (j > split.length - j) continue;
            rebuild = (String)rebuild + ".";
        }
        return rebuild;
    }

    int getLayerFromLine(String line, int lineNumber) {
        double d = 0.0;
        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
            d += 0.5;
        }
        return (int)d;
    }

    private Configuration getSectionFor(String path) {
        int index = path.indexOf(46);
        if (index == -1) {
            return this;
        }
        String root = path.substring(0, index);
        Object section = this.self.get(root);
        if (section == null) {
            section = new Configuration(this.defaults == null ? null : this.defaults.getSection(root));
            this.self.put(root, section);
        }
        return (Configuration)section;
    }

    private String getChild(String path) {
        int index = path.indexOf(46);
        return index == -1 ? path : path.substring(index + 1);
    }

    public <T> T get(String path, T def) {
        Configuration section = this.getSectionFor(path);
        Object val = section == this ? this.self.get(path) : section.get(this.getChild(path), def);
        if (val == null && def instanceof Configuration) {
            this.self.put(path, def);
        }
        return (T)(val != null ? val : def);
    }

    public boolean contains(String path) {
        return this.get(path, null) != null;
    }

    public Object get(String path) {
        return this.get(path, this.getDefault(path));
    }

    public Object getDefault(String path) {
        return this.defaults == null ? null : this.defaults.get(path);
    }

    public void set(String path, Object value) {
        Configuration section;
        if (value instanceof Map) {
            value = new Configuration((Map)value, this.defaults == null ? null : this.defaults.getSection(path));
        }
        if ((section = this.getSectionFor(path)) == this) {
            if (value == null) {
                this.self.remove(path);
            } else {
                this.self.put(path, value);
            }
        } else {
            section.set(this.getChild(path), value);
        }
    }

    public Configuration getSection(String path) {
        Object def = this.getDefault(path);
        return (Configuration)this.get(path, def instanceof Configuration ? def : new Configuration(this.defaults == null ? null : this.defaults.getSection(path)));
    }

    public Collection<String> getKeys() {
        return new LinkedHashSet<String>(this.self.keySet());
    }

    public byte getByte(String path) {
        Object def = this.getDefault(path);
        return this.getByte(path, def instanceof Number ? ((Number)def).byteValue() : (byte)0);
    }

    public byte getByte(String path, byte def) {
        Byte val = this.get(path, def);
        return val instanceof Number ? ((Number)val).byteValue() : def;
    }

    public List<Byte> getByteList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).byteValue());
        }
        return result;
    }

    public short getShort(String path) {
        Object def = this.getDefault(path);
        return this.getShort(path, def instanceof Number ? ((Number)def).shortValue() : (short)0);
    }

    public short getShort(String path, short def) {
        Short val = this.get(path, def);
        return val instanceof Number ? ((Number)val).shortValue() : def;
    }

    public List<Short> getShortList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Short> result = new ArrayList<Short>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).shortValue());
        }
        return result;
    }

    public int getInt(String path) {
        Object def = this.getDefault(path);
        return this.getInt(path, def instanceof Number ? ((Number)def).intValue() : 0);
    }

    public int getInt(String path, int def) {
        Integer val = this.get(path, def);
        return val instanceof Number ? ((Number)val).intValue() : def;
    }

    public List<Integer> getIntList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).intValue());
        }
        return result;
    }

    public long getLong(String path) {
        Object def = this.getDefault(path);
        return this.getLong(path, def instanceof Number ? ((Number)def).longValue() : 0L);
    }

    public long getLong(String path, long def) {
        Long val = this.get(path, def);
        return val instanceof Number ? ((Number)val).longValue() : def;
    }

    public List<Long> getLongList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).longValue());
        }
        return result;
    }

    public float getFloat(String path) {
        Object def = this.getDefault(path);
        return this.getFloat(path, def instanceof Number ? ((Number)def).floatValue() : 0.0f);
    }

    public float getFloat(String path, float def) {
        Float val = this.get(path, Float.valueOf(def));
        return val instanceof Number ? ((Number)val).floatValue() : def;
    }

    public List<Float> getFloatList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Float> result = new ArrayList<Float>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(Float.valueOf(((Number)object).floatValue()));
        }
        return result;
    }

    public double getDouble(String path) {
        Object def = this.getDefault(path);
        return this.getDouble(path, def instanceof Number ? ((Number)def).doubleValue() : 0.0);
    }

    public double getDouble(String path, double def) {
        Double val = this.get(path, def);
        return val instanceof Number ? ((Number)val).doubleValue() : def;
    }

    public List<Double> getDoubleList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Double> result = new ArrayList<Double>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).doubleValue());
        }
        return result;
    }

    public boolean getBoolean(String path) {
        Object def = this.getDefault(path);
        return this.getBoolean(path, def instanceof Boolean ? (Boolean)def : false);
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean val = this.get(path, def);
        return val instanceof Boolean ? val : def;
    }

    public List<Boolean> getBooleanList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object object : list) {
            if (!(object instanceof Boolean)) continue;
            result.add((Boolean)object);
        }
        return result;
    }

    public char getChar(String path) {
        Object def = this.getDefault(path);
        return this.getChar(path, def instanceof Character ? ((Character)def).charValue() : (char)'\u0000');
    }

    public char getChar(String path, char def) {
        Character val = this.get(path, Character.valueOf(def));
        return val instanceof Character ? val.charValue() : def;
    }

    public List<Character> getCharList(String path) {
        List<?> list = this.getList(path);
        ArrayList<Character> result = new ArrayList<Character>();
        for (Object object : list) {
            if (!(object instanceof Character)) continue;
            result.add((Character)object);
        }
        return result;
    }

    public String getString(String path) {
        Object def = this.getDefault(path);
        return this.getString(path, def instanceof String ? (String)def : "");
    }

    public String getString(String path, String def) {
        String val = this.get(path, def);
        return val instanceof String ? val : def;
    }

    public List<String> getStringList(String path) {
        List<?> list = this.getList(path);
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : list) {
            if (!(object instanceof String)) continue;
            result.add((String)object);
        }
        return result;
    }

    public List<?> getList(String path) {
        Object def = this.getDefault(path);
        return this.getList(path, def instanceof List ? (List)def : Collections.EMPTY_LIST);
    }

    public List<?> getList(String path, List<?> def) {
        List<?> val = this.get(path, def);
        return val instanceof List ? val : def;
    }
}

