/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.api;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.utils.ConfigDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VPNConfig {
    private final ConfigDefault<String> licenseDefault = new ConfigDefault<String>("", "license", AntiVPN.getInstance());
    private final ConfigDefault<String> kickStringDefault = new ConfigDefault<String>("Proxies are not allowed on our server", "kickMessage", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultDatabaseType = new ConfigDefault<String>("H2", "database.type", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultDatabaseName = new ConfigDefault<String>("kaurivpn", "database.database", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultMongoURL = new ConfigDefault<String>("", "database.mongoURL", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultUsername = new ConfigDefault<String>("root", "database.username", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultPassword = new ConfigDefault<String>("password", "database.password", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultCountryKickReason = new ConfigDefault<String>("&cSorry, but our server does not allow connections from\n&f%country%", "countries.vanillaKickReason", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultIp = new ConfigDefault<String>("localhost", "database.ip", AntiVPN.getInstance());
    private final ConfigDefault<String> defaultAlertMsg = new ConfigDefault<String>("&8[&6KauriVPN&8] &e%player% &7has joined on a VPN/proxy &8(&f%reason%&8) &7in location &8(&f%city%&7, &f%country%&8)", "alerts.message", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> cacheResultsDefault = new ConfigDefault<Boolean>(true, "cachedResults", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> defaultUseCredentials = new ConfigDefault<Boolean>(true, "database.useCredentials", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> defaultDatabaseEnabled = new ConfigDefault<Boolean>(false, "database.enabled", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> defaultCommandsEnable = new ConfigDefault<Boolean>(false, "commands.enabled", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> defaultKickPlayers = new ConfigDefault<Boolean>(true, "kickPlayers", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> defaultAlertToStaff = new ConfigDefault<Boolean>(true, "alerts.enabled", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> defaultWhitelistCountries = new ConfigDefault<Boolean>(true, "countries.whitelist", AntiVPN.getInstance());
    private final ConfigDefault<Boolean> defaultMetrics = new ConfigDefault<Boolean>(true, "bstats", AntiVPN.getInstance());
    private final ConfigDefault<Integer> defaultPort = new ConfigDefault<Integer>(-1, "database.port", AntiVPN.getInstance());
    private final ConfigDefault<List<String>> prefixWhitelistsDefault = new ConfigDefault(new ArrayList(), "prefixWhitelists", AntiVPN.getInstance());
    private final ConfigDefault<List<String>> defaultCommands = new ConfigDefault<List<String>>(Collections.singletonList("kick %player% VPNs are not allowed on our server!"), "commands.execute", AntiVPN.getInstance());
    private final ConfigDefault<List<String>> defCountryKickCommands = new ConfigDefault(Collections.emptyList(), "countries.commands", AntiVPN.getInstance());
    private final ConfigDefault<List<String>> defCountrylist = new ConfigDefault(new ArrayList(), "countries.list", AntiVPN.getInstance());
    private String license;
    private String kickMessage;
    private String databaseType;
    private String databaseName;
    private String mongoURL;
    private String username;
    private String password;
    private String ip;
    private String alertMsg;
    private String countryVanillaKickReason;
    private List<String> prefixWhitelists;
    private List<String> commands;
    private List<String> countryList;
    private List<String> countryKickCommands;
    private int port;
    private boolean cacheResults;
    private boolean databaseEnabled;
    private boolean useCredentials;
    private boolean commandsEnabled;
    private boolean kickPlayers;
    private boolean alertToStaff;
    private boolean metrics;
    private boolean whitelistCountries;

    public String getLicense() {
        return this.license;
    }

    public boolean cachedResults() {
        return this.cacheResults;
    }

    public String getKickString() {
        return this.kickMessage;
    }

    public String alertMessage() {
        return this.alertMsg;
    }

    public boolean alertToStaff() {
        return this.alertToStaff;
    }

    public boolean runCommands() {
        return this.commandsEnabled;
    }

    public List<String> commands() {
        return this.commands;
    }

    public boolean kickPlayersOnDetect() {
        return this.kickPlayers;
    }

    public List<String> getPrefixWhitelists() {
        return this.prefixWhitelists;
    }

    public boolean isDatabaseEnabled() {
        return this.databaseEnabled;
    }

    public boolean useDatabaseCreds() {
        return this.useCredentials;
    }

    public String mongoDatabaseURL() {
        return this.mongoURL;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIp() {
        return this.ip;
    }

    public List<String> countryList() {
        return this.countryList;
    }

    public boolean whitelistCountries() {
        return this.whitelistCountries;
    }

    public List<String> countryKickCommands() {
        return this.countryKickCommands;
    }

    public String countryVanillaKickReason() {
        return this.countryVanillaKickReason;
    }

    public int getPort() {
        if (this.port == -1) {
            switch (this.getDatabaseType().toLowerCase()) {
                case "mongodb": 
                case "mongo": 
                case "mongod": {
                    return 27017;
                }
                case "sql": 
                case "mysql": {
                    return 3306;
                }
            }
        }
        return this.port;
    }

    public boolean metrics() {
        return this.metrics;
    }

    public void update() {
        this.license = this.licenseDefault.get();
        this.kickMessage = this.kickStringDefault.get();
        this.cacheResults = this.cacheResultsDefault.get();
        this.prefixWhitelists = this.prefixWhitelistsDefault.get();
        this.databaseEnabled = this.defaultDatabaseEnabled.get();
        this.useCredentials = this.defaultUseCredentials.get();
        this.databaseType = this.defaultDatabaseType.get();
        this.databaseName = this.defaultDatabaseName.get();
        this.mongoURL = this.defaultMongoURL.get();
        this.username = this.defaultUsername.get();
        this.password = this.defaultPassword.get();
        this.ip = this.defaultIp.get();
        this.port = this.defaultPort.get();
        this.commandsEnabled = this.defaultCommandsEnable.get();
        this.commands = this.defaultCommands.get();
        this.kickPlayers = this.defaultKickPlayers.get();
        this.alertToStaff = this.defaultAlertToStaff.get();
        this.alertMsg = this.defaultAlertMsg.get();
        this.metrics = this.defaultMetrics.get();
        this.countryList = this.defCountrylist.get();
        this.whitelistCountries = this.defaultWhitelistCountries.get();
        this.countryKickCommands = this.defCountryKickCommands.get();
        this.countryVanillaKickReason = this.defaultCountryKickReason.get();
    }
}

