/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.api;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.shaded.com.google.common.cache.Cache;
import dev.brighten.antivpn.shaded.com.google.common.cache.CacheBuilder;
import dev.brighten.antivpn.utils.json.JSONException;
import dev.brighten.antivpn.web.FunkemunkyAPI;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;

public abstract class VPNExecutor {
    public static ScheduledExecutorService threadExecutor = Executors.newScheduledThreadPool(2);
    private final Set<UUID> whitelisted = Collections.synchronizedSet(new HashSet());
    private final Set<String> whitelistedIps = Collections.synchronizedSet(new HashSet());
    private final Cache<String, VPNResponse> responseCache = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.MINUTES).maximumSize(4000L).build();

    public abstract void registerListeners();

    public abstract void shutdown();

    public abstract void log(Level var1, String var2, Object ... var3);

    public abstract void log(String var1, Object ... var2);

    public abstract void logException(String var1, Exception var2);

    public void logException(Exception ex) {
        this.logException("An exception occurred: " + ex.getMessage(), ex);
    }

    public boolean isWhitelisted(UUID uuid) {
        if (AntiVPN.getInstance().getVpnConfig().isDatabaseEnabled()) {
            return AntiVPN.getInstance().getDatabase().isWhitelisted(uuid);
        }
        return this.whitelisted.contains(uuid);
    }

    public boolean isWhitelisted(String ip) {
        if (AntiVPN.getInstance().getVpnConfig().isDatabaseEnabled()) {
            return AntiVPN.getInstance().getDatabase().isWhitelisted(ip);
        }
        return this.whitelistedIps.contains(ip);
    }

    public void checkIp(String ip, boolean cachedResults, Consumer<VPNResponse> result) {
        threadExecutor.execute(() -> {
            if (cachedResults) {
                try {
                    result.accept(this.responseCache.get(ip, () -> this.checkIp(ip)));
                }
                catch (ExecutionException e) {
                    this.log("Failed to process checkIp() method! Reason: " + e.getMessage(), new Object[0]);
                    result.accept(VPNResponse.FAILED_RESPONSE);
                }
            } else {
                result.accept(this.checkIp(ip));
            }
        });
    }

    public VPNResponse checkIp(String ip) {
        Optional<VPNResponse> cachedRes = AntiVPN.getInstance().getDatabase().getStoredResponse(ip);
        if (cachedRes.isPresent()) {
            return cachedRes.get();
        }
        try {
            VPNResponse response = FunkemunkyAPI.getVPNResponse(ip, AntiVPN.getInstance().getVpnConfig().getLicense(), true);
            if (response.isSuccess()) {
                AntiVPN.getInstance().getDatabase().cacheResponse(response);
            } else {
                this.log("Query to VPN API failed! Reason: " + response.getFailureReason(), new Object[0]);
            }
            return response;
        }
        catch (JSONException | IOException e) {
            this.log("Query to VPN API failed! Reason: " + e.getMessage(), new Object[0]);
            return VPNResponse.FAILED_RESPONSE;
        }
    }

    public Set<UUID> getWhitelisted() {
        return this.whitelisted;
    }

    public Set<String> getWhitelistedIps() {
        return this.whitelistedIps;
    }
}

