/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bukkit;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.VPNExecutor;
import dev.brighten.antivpn.bukkit.BukkitPlugin;
import dev.brighten.antivpn.message.VpnString;
import dev.brighten.antivpn.shaded.com.google.common.cache.Cache;
import dev.brighten.antivpn.shaded.com.google.common.cache.CacheBuilder;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitListener
extends VPNExecutor
implements Listener {
    private final Cache<UUID, VPNResponse> responseCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(2000L).build();

    @Override
    public void registerListeners() {
        BukkitPlugin.pluginInstance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)BukkitPlugin.pluginInstance);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void log(Level level, String log, Object ... objects) {
        Bukkit.getLogger().log(level, String.format(log, objects));
    }

    @Override
    public void log(String log, Object ... objects) {
        this.log(Level.INFO, String.format(log, objects), new Object[0]);
    }

    @Override
    public void logException(String message, Exception ex) {
        Bukkit.getLogger().log(Level.SEVERE, message, ex);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        AntiVPN.getInstance().getPlayerExecutor().getPlayer(event.getPlayer().getUniqueId()).ifPresent(player -> AntiVPN.getInstance().getDatabase().alertsState(player.getUuid(), enabled -> {
            if (enabled.booleanValue()) {
                player.setAlertsEnabled(true);
                player.sendMessage(AntiVPN.getInstance().getMessageHandler().getString("command-alerts-toggled").getFormattedMessage(new VpnString.Var("state", true)));
            }
        }));
    }

    @EventHandler
    public void onListener(final PlayerLoginEvent event) {
        VPNResponse cached;
        if (event.getPlayer().hasPermission("antivpn.bypass") || AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getUniqueId()) || AntiVPN.getInstance().getExecutor().isWhitelisted(event.getAddress().getHostAddress()) || AntiVPN.getInstance().getVpnConfig().getPrefixWhitelists().stream().anyMatch(prefix -> event.getPlayer().getName().startsWith((String)prefix))) {
            return;
        }
        if (this.responseCache.asMap().containsKey(event.getPlayer().getUniqueId()) && (cached = this.responseCache.getIfPresent(event.getPlayer().getUniqueId())) != null && cached.isProxy()) {
            event.setResult(PlayerLoginEvent.Result.KICK_BANNED);
            event.setKickMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)AntiVPN.getInstance().getVpnConfig().getKickString()));
            return;
        }
        final Player player = event.getPlayer();
        this.checkIp(event.getAddress().getHostAddress(), AntiVPN.getInstance().getVpnConfig().cachedResults(), result -> {
            if (result.isSuccess()) {
                InetAddress address1;
                if (AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getUniqueId())) {
                    this.log("UUID is whitelisted: %s", event.getPlayer().getUniqueId().toString());
                    return;
                }
                InetSocketAddress address = event.getPlayer().getAddress();
                if (address != null && (address1 = address.getAddress()) != null && AntiVPN.getInstance().getExecutor().isWhitelisted(address1.getHostAddress())) {
                    this.log("IP is whitelisted: %s", address1.getHostAddress());
                    return;
                }
                if (!AntiVPN.getInstance().getVpnConfig().countryList().isEmpty() && AntiVPN.getInstance().getVpnConfig().countryList().contains(result.getCountryCode()) != AntiVPN.getInstance().getVpnConfig().whitelistCountries()) {
                    final String kickReason = AntiVPN.getInstance().getVpnConfig().countryVanillaKickReason();
                    event.setResult(PlayerLoginEvent.Result.KICK_BANNED);
                    event.setKickMessage(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)kickReason.replace("%player%", event.getPlayer().getName()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode())));
                    if (AntiVPN.getInstance().getVpnConfig().countryKickCommands().isEmpty()) {
                        new BukkitRunnable((VPNResponse)result){
                            final /* synthetic */ VPNResponse val$result;
                            {
                                this.val$result = vPNResponse;
                            }

                            public void run() {
                                event.getPlayer().kickPlayer(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)kickReason.replace("%player%", event.getPlayer().getName()).replace("%country%", this.val$result.getCountryName()).replace("%code%", this.val$result.getCountryCode())));
                            }
                        }.runTask((Plugin)BukkitPlugin.pluginInstance);
                    } else {
                        String playerName = event.getPlayer().getName();
                        BukkitPlugin.pluginInstance.getPlayerCommandRunner().addAction(event.getPlayer().getUniqueId(), () -> {
                            for (String cmd : AntiVPN.getInstance().getVpnConfig().countryKickCommands()) {
                                String formattedCommand = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)cmd.replace("%player%", playerName).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode()));
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)formattedCommand);
                            }
                        });
                    }
                } else if (result.isProxy()) {
                    event.setResult(PlayerLoginEvent.Result.KICK_BANNED);
                    event.setKickMessage(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)AntiVPN.getInstance().getVpnConfig().getKickString().replace("%player%", event.getPlayer().getName()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode())));
                    if (AntiVPN.getInstance().getVpnConfig().kickPlayersOnDetect()) {
                        new BukkitRunnable(){

                            public void run() {
                                player.kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)AntiVPN.getInstance().getVpnConfig().getKickString()));
                            }
                        }.runTask((Plugin)BukkitPlugin.pluginInstance);
                    }
                    this.log(Level.INFO, event.getPlayer().getName() + " joined on a VPN/Proxy (" + result.getMethod() + ")", new Object[0]);
                    if (AntiVPN.getInstance().getVpnConfig().alertToStaff()) {
                        AntiVPN.getInstance().getPlayerExecutor().getOnlinePlayers().stream().filter(APIPlayer::isAlertsEnabled).forEach(pl -> pl.sendMessage(AntiVPN.getInstance().getVpnConfig().alertMessage().replace("%player%", event.getPlayer().getName()).replace("%reason%", result.getMethod()).replace("%country%", result.getCountryName()).replace("%city%", result.getCity())));
                    }
                    if (AntiVPN.getInstance().getVpnConfig().runCommands()) {
                        String playerName = event.getPlayer().getName();
                        BukkitPlugin.pluginInstance.getPlayerCommandRunner().addAction(event.getPlayer().getUniqueId(), () -> {
                            for (String command : AntiVPN.getInstance().getVpnConfig().commands()) {
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)command.replace("%player%", playerName)));
                            }
                        });
                    }
                    ++AntiVPN.getInstance().detections;
                }
            } else {
                this.log(Level.WARNING, "The API query was not a success! You may need to upgrade your license on https://funkemunky.cc/shop", new Object[0]);
            }
            ++AntiVPN.getInstance().checked;
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        AntiVPN.getInstance().getPlayerExecutor().unloadPlayer(event.getPlayer().getUniqueId());
    }
}

