/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bukkit;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.bukkit.BukkitListener;
import dev.brighten.antivpn.bukkit.BukkitPlayerExecutor;
import dev.brighten.antivpn.bukkit.PlayerCommandRunner;
import dev.brighten.antivpn.bukkit.command.BukkitCommand;
import dev.brighten.antivpn.bukkit.org.bstats.bukkit.Metrics;
import dev.brighten.antivpn.bukkit.org.bstats.charts.SingleLineChart;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitPlugin
extends JavaPlugin {
    public static BukkitPlugin pluginInstance;
    private SimpleCommandMap commandMap;
    private final List<Command> registeredCommands = new ArrayList<Command>();
    private SingleLineChart vpnDetections;
    private SingleLineChart ipsChecked;
    private PlayerCommandRunner playerCommandRunner;

    public void onEnable() {
        pluginInstance = this;
        Bukkit.getLogger().info("Starting AntiVPN services...");
        AntiVPN.start(new BukkitListener(), new BukkitPlayerExecutor(), this.getDataFolder());
        this.playerCommandRunner = new PlayerCommandRunner();
        this.playerCommandRunner.start();
        if (AntiVPN.getInstance().getVpnConfig().metrics()) {
            Bukkit.getLogger().info("Starting bStats metrics...");
            Metrics metrics = new Metrics(this, 12615);
            this.vpnDetections = new SingleLineChart("vpn_detections", () -> AntiVPN.getInstance().detections);
            metrics.addCustomChart(this.vpnDetections);
            this.ipsChecked = new SingleLineChart("ips_checked", () -> AntiVPN.getInstance().checked);
            metrics.addCustomChart(this.ipsChecked);
            new BukkitRunnable(){

                public void run() {
                    AntiVPN.getInstance().detections = 0;
                    AntiVPN.getInstance().checked = 0;
                }
            }.runTaskTimerAsynchronously((Plugin)this, 12000L, 12000L);
        }
        Bukkit.getLogger().info("Setting up and registering commands...");
        if (pluginInstance.getServer().getPluginManager() instanceof SimplePluginManager) {
            SimplePluginManager manager = (SimplePluginManager)pluginInstance.getServer().getPluginManager();
            try {
                Field field = SimplePluginManager.class.getDeclaredField("commandMap");
                field.setAccessible(true);
                this.commandMap = (SimpleCommandMap)field.get(manager);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        for (dev.brighten.antivpn.command.Command command : AntiVPN.getInstance().getCommands()) {
            BukkitCommand newCommand = new BukkitCommand(command);
            this.registeredCommands.add(newCommand);
            this.commandMap.register(pluginInstance.getName(), (Command)newCommand);
        }
        this.reloadConfig();
    }

    public void onDisable() {
        Bukkit.getLogger().info("Stopping plugin services...");
        AntiVPN.getInstance().stop();
        this.playerCommandRunner.stop();
        Bukkit.getLogger().info("Unregistering commands...");
        try {
            Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
            Map knownCommands = (Map)field.get(this.commandMap);
            knownCommands.values().removeAll(this.registeredCommands);
            this.registeredCommands.clear();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        Bukkit.getLogger().info("Unregistering listeners...");
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getLogger().info("Cancelling any running tasks...");
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public SingleLineChart getVpnDetections() {
        return this.vpnDetections;
    }

    public SingleLineChart getIpsChecked() {
        return this.ipsChecked;
    }

    public PlayerCommandRunner getPlayerCommandRunner() {
        return this.playerCommandRunner;
    }
}

