/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bungee;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.VPNExecutor;
import dev.brighten.antivpn.bungee.BungeePlugin;
import dev.brighten.antivpn.shaded.com.google.common.cache.Cache;
import dev.brighten.antivpn.shaded.com.google.common.cache.CacheBuilder;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.event.EventHandler;

public class BungeeListener
extends VPNExecutor
implements Listener {
    private ScheduledTask cacheResetTask;
    private final Cache<UUID, VPNResponse> responseCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(2000L).build();

    @Override
    public void registerListeners() {
        BungeePlugin.pluginInstance.getProxy().getPluginManager().registerListener((Plugin)BungeePlugin.pluginInstance, (Listener)this);
    }

    @Override
    public void shutdown() {
        if (this.cacheResetTask != null) {
            this.cacheResetTask.cancel();
            this.cacheResetTask = null;
        }
        threadExecutor.shutdown();
        BungeePlugin.pluginInstance.getProxy().getPluginManager().unregisterListener((Listener)this);
    }

    @Override
    public void log(Level level, String log, Object ... objects) {
        BungeeCord.getInstance().getLogger().log(Level.INFO, String.format(log, objects));
    }

    @Override
    public void log(String log, Object ... objects) {
        this.log(Level.INFO, String.format(log, objects), new Object[0]);
    }

    @Override
    public void logException(String message, Exception ex) {
        BungeeCord.getInstance().getLogger().log(Level.SEVERE, message, ex);
    }

    @EventHandler(priority=-64)
    public void onListener(PreLoginEvent event) {
        if (!this.responseCache.asMap().containsKey(event.getConnection().getUniqueId())) {
            return;
        }
        VPNResponse cached = this.responseCache.getIfPresent(event.getConnection().getUniqueId());
        if (cached != null && cached.isProxy()) {
            event.setCancelled(true);
            event.setCancelReason(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)AntiVPN.getInstance().getVpnConfig().getKickString())));
            AntiVPN.getInstance().getExecutor().log(Level.INFO, "%s was kicked from pre-login proxy cache.", event.getConnection().getName());
        }
    }

    @EventHandler(priority=-64)
    public void onListener(PostLoginEvent event) {
        if (event.getPlayer().hasPermission("antivpn.bypass") || AntiVPN.getInstance().getVpnConfig().getPrefixWhitelists().stream().anyMatch(prefix -> event.getPlayer().getName().startsWith((String)prefix))) {
            return;
        }
        this.checkIp(event.getPlayer().getAddress().getAddress().getHostAddress(), AntiVPN.getInstance().getVpnConfig().cachedResults(), result -> {
            if (result.isSuccess()) {
                if (AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getUniqueId())) {
                    AntiVPN.getInstance().getExecutor().log("UUID is whitelisted: %s", event.getPlayer().getUniqueId().toString());
                    return;
                }
                if (AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getAddress().getAddress().getHostAddress())) {
                    AntiVPN.getInstance().getExecutor().log("IP is whitelisted: %s", event.getPlayer().getAddress().getAddress().getHostAddress());
                    return;
                }
                this.responseCache.put(event.getPlayer().getUniqueId(), (VPNResponse)result);
                if (!AntiVPN.getInstance().getVpnConfig().countryList().isEmpty() && AntiVPN.getInstance().getVpnConfig().countryList().contains(result.getCountryCode()) != AntiVPN.getInstance().getVpnConfig().whitelistCountries()) {
                    if (AntiVPN.getInstance().getVpnConfig().countryKickCommands().isEmpty()) {
                        String kickReason = AntiVPN.getInstance().getVpnConfig().countryVanillaKickReason();
                        event.getPlayer().disconnect(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)kickReason.replace("%player%", event.getPlayer().getName()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode()))));
                    } else {
                        for (String cmd : AntiVPN.getInstance().getVpnConfig().countryKickCommands()) {
                            String formattedCommand = ChatColor.translateAlternateColorCodes((char)'&', (String)cmd.replace("%player%", event.getPlayer().getName()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode()));
                            BungeeCord.getInstance().getPluginManager().dispatchCommand(BungeeCord.getInstance().getConsole(), formattedCommand);
                        }
                    }
                } else if (result.isProxy()) {
                    if (AntiVPN.getInstance().getVpnConfig().kickPlayersOnDetect()) {
                        event.getPlayer().disconnect(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)AntiVPN.getInstance().getVpnConfig().getKickString())));
                    }
                    BungeeCord.getInstance().getLogger().info(event.getPlayer().getName() + " joined on a VPN/Proxy (" + result.getMethod() + ")");
                    if (AntiVPN.getInstance().getVpnConfig().alertToStaff()) {
                        AntiVPN.getInstance().getPlayerExecutor().getOnlinePlayers().stream().filter(APIPlayer::isAlertsEnabled).forEach(pl -> pl.sendMessage(AntiVPN.getInstance().getVpnConfig().alertMessage().replace("%player%", event.getPlayer().getName()).replace("%reason%", result.getMethod()).replace("%country%", result.getCountryName()).replace("%city%", result.getCity())));
                    }
                    if (AntiVPN.getInstance().getVpnConfig().runCommands()) {
                        for (String command : AntiVPN.getInstance().getVpnConfig().commands()) {
                            BungeeCord.getInstance().getPluginManager().dispatchCommand(BungeeCord.getInstance().getConsole(), ChatColor.translateAlternateColorCodes((char)'&', (String)command.replace("%player%", event.getPlayer().getName())));
                        }
                    }
                    ++AntiVPN.getInstance().detections;
                }
            } else {
                BungeeCord.getInstance().getLogger().log(Level.WARNING, "The API query was not a success! You may need to upgrade your license on https://funkemunky.cc/shop");
            }
            ++AntiVPN.getInstance().checked;
        });
    }

    @EventHandler
    public void onLeave(PlayerDisconnectEvent event) {
        AntiVPN.getInstance().getPlayerExecutor().unloadPlayer(event.getPlayer().getUniqueId());
    }
}

