/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bungee;

import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.PlayerExecutor;
import dev.brighten.antivpn.bungee.BungeePlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeePlayerExecutor
implements PlayerExecutor {
    private final Map<UUID, BungeePlayer> cachedPlayers = new HashMap<UUID, BungeePlayer>();

    @Override
    public Optional<APIPlayer> getPlayer(String name) {
        ProxiedPlayer player = BungeeCord.getInstance().getPlayer(name);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of((APIPlayer)this.cachedPlayers.computeIfAbsent(player.getUniqueId(), key -> new BungeePlayer(player)));
    }

    @Override
    public Optional<APIPlayer> getPlayer(UUID uuid) {
        ProxiedPlayer player = BungeeCord.getInstance().getPlayer(uuid);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of((APIPlayer)this.cachedPlayers.computeIfAbsent(uuid, key -> new BungeePlayer(player)));
    }

    @Override
    public void unloadPlayer(UUID uuid) {
        this.cachedPlayers.remove(uuid);
    }

    @Override
    public List<APIPlayer> getOnlinePlayers() {
        return BungeeCord.getInstance().getPlayers().stream().map(pl -> this.cachedPlayers.computeIfAbsent(pl.getUniqueId(), key -> new BungeePlayer((ProxiedPlayer)pl))).collect(Collectors.toList());
    }
}

