/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bungee;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.bungee.BungeeListener;
import dev.brighten.antivpn.bungee.BungeePlayerExecutor;
import dev.brighten.antivpn.bungee.command.BungeeCommand;
import dev.brighten.antivpn.bungee.org.bstats.bungeecord.Metrics;
import dev.brighten.antivpn.bungee.org.bstats.charts.SingleLineChart;
import dev.brighten.antivpn.command.Command;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeePlugin
extends Plugin {
    public static BungeePlugin pluginInstance;
    private SingleLineChart vpnDetections;
    private SingleLineChart ipsChecked;

    public void onEnable() {
        pluginInstance = this;
        BungeeCord.getInstance().getLogger().info("Loading config...");
        BungeeCord.getInstance().getLogger().info("Starting AntiVPN services...");
        AntiVPN.start(new BungeeListener(), new BungeePlayerExecutor(), this.getDataFolder());
        if (AntiVPN.getInstance().getVpnConfig().metrics()) {
            BungeeCord.getInstance().getLogger().info("Starting bStats metrics...");
            Metrics metrics = new Metrics(this, 12616);
            this.vpnDetections = new SingleLineChart("vpn_detections", () -> AntiVPN.getInstance().detections);
            metrics.addCustomChart(this.vpnDetections);
            this.ipsChecked = new SingleLineChart("ips_checked", () -> AntiVPN.getInstance().checked);
            metrics.addCustomChart(this.ipsChecked);
            BungeeCord.getInstance().getScheduler().schedule((Plugin)this, () -> {
                AntiVPN.getInstance().detections = 0;
                AntiVPN.getInstance().checked = 0;
            }, 10L, 10L, TimeUnit.MINUTES);
        }
        for (Command command : AntiVPN.getInstance().getCommands()) {
            BungeeCord.getInstance().getPluginManager().registerCommand((Plugin)pluginInstance, (net.md_5.bungee.api.plugin.Command)new BungeeCommand(command));
        }
    }

    public void onDisable() {
        AntiVPN.getInstance().stop();
    }
}

