/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.database.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.UpdateOptions;
import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.api.VPNExecutor;
import dev.brighten.antivpn.database.VPNDatabase;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoVPN
implements VPNDatabase {
    private MongoCollection<Document> settingsDocument;
    private MongoCollection<Document> cacheDocument;
    private MongoClient client;

    public MongoVPN() {
        VPNExecutor.threadExecutor.scheduleAtFixedRate(() -> {
            if (!AntiVPN.getInstance().getVpnConfig().isDatabaseEnabled()) {
                return;
            }
            AntiVPN.getInstance().getExecutor().getWhitelisted().clear();
            AntiVPN.getInstance().getExecutor().getWhitelisted().addAll(AntiVPN.getInstance().getDatabase().getAllWhitelisted());
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().clear();
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().addAll(AntiVPN.getInstance().getDatabase().getAllWhitelistedIps());
        }, 2L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public Optional<VPNResponse> getStoredResponse(String ip) {
        Document rdoc = (Document)this.cacheDocument.find(Filters.eq("ip", ip)).first();
        if (rdoc != null) {
            long lastUpdate = rdoc.get((Object)"lastAccess", 0L);
            if (System.currentTimeMillis() - lastUpdate > TimeUnit.HOURS.toMillis(1L)) {
                VPNExecutor.threadExecutor.execute(() -> this.deleteResponse(ip));
                return Optional.empty();
            }
            return Optional.of(VPNResponse.builder().asn(rdoc.getString("asn")).ip(ip).countryName(rdoc.getString("countryName")).countryCode(rdoc.getString("countryCode")).city(rdoc.getString("city")).isp(rdoc.getString("isp")).method(rdoc.getString("method")).timeZone(rdoc.getString("timeZone")).proxy(rdoc.getBoolean("proxy")).cached(rdoc.getBoolean("cached")).success(true).latitude(rdoc.getDouble("latitude")).longitude(rdoc.getDouble("longitude")).lastAccess(rdoc.get((Object)"lastAccess", 0L)).build());
        }
        return Optional.empty();
    }

    @Override
    public void cacheResponse(VPNResponse toCache) {
        Document rdoc = new Document("ip", toCache.getIp());
        rdoc.put("asn", (Object)toCache.getAsn());
        rdoc.put("countryName", (Object)toCache.getCountryName());
        rdoc.put("countryCode", (Object)toCache.getCountryCode());
        rdoc.put("city", (Object)toCache.getCity());
        rdoc.put("isp", (Object)toCache.getIsp());
        rdoc.put("method", (Object)toCache.getMethod());
        rdoc.put("timeZone", (Object)toCache.getTimeZone());
        rdoc.put("proxy", (Object)toCache.isProxy());
        rdoc.put("cached", (Object)toCache.isCached());
        rdoc.put("success", (Object)toCache.isSuccess());
        rdoc.put("latitude", (Object)toCache.getLatitude());
        rdoc.put("longitude", (Object)toCache.getLongitude());
        rdoc.put("lastAccess", (Object)System.currentTimeMillis());
        VPNExecutor.threadExecutor.execute(() -> {
            Document update = new Document("$set", rdoc);
            this.cacheDocument.updateOne(Filters.eq("ip", toCache.getIp()), (Bson)update, new UpdateOptions().upsert(true));
        });
    }

    @Override
    public void deleteResponse(String ip) {
        this.cacheDocument.deleteMany(Filters.eq("ip", ip));
    }

    @Override
    public boolean isWhitelisted(UUID uuid) {
        return this.settingsDocument.find(Filters.and(Filters.eq("setting", "whitelist"), Filters.eq("uuid", uuid.toString()))).first() != null;
    }

    @Override
    public boolean isWhitelisted(String ip) {
        return this.settingsDocument.find(Filters.and(Filters.eq("setting", "whitelist"), Filters.eq("ip", ip))).first() != null;
    }

    @Override
    public void setWhitelisted(UUID uuid, boolean whitelisted) {
        if (whitelisted) {
            Document wdoc = new Document("setting", "whitelist");
            wdoc.put("uuid", (Object)uuid.toString());
            AntiVPN.getInstance().getExecutor().getWhitelisted().add(uuid);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.insertOne(wdoc));
        } else {
            AntiVPN.getInstance().getExecutor().getWhitelisted().remove(uuid);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.deleteMany(Filters.and(Filters.eq("setting", "whitelist"), Filters.eq("uuid", uuid.toString()))));
        }
    }

    @Override
    public void setWhitelisted(String ip, boolean whitelisted) {
        if (whitelisted) {
            Document wdoc = new Document("setting", "whitelist").append("ip", ip);
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().add(ip);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.insertOne(wdoc));
        } else {
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().remove(ip);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.deleteMany(Filters.and(Filters.eq("setting", "whitelist"), Filters.eq("ip", ip))));
        }
    }

    @Override
    public List<UUID> getAllWhitelisted() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        this.settingsDocument.find(Filters.and(Filters.eq("setting", "whitelist"), Filters.exists("uuid"))).forEach(doc -> uuids.add(UUID.fromString(doc.getString("uuid"))));
        return uuids;
    }

    @Override
    public List<String> getAllWhitelistedIps() {
        ArrayList<String> ips = new ArrayList<String>();
        this.settingsDocument.find(Filters.and(Filters.eq("setting", "whitelist"), Filters.exists("ip"))).forEach(doc -> ips.add(doc.getString("ip")));
        return ips;
    }

    @Override
    public void getStoredResponseAsync(String ip, Consumer<Optional<VPNResponse>> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.getStoredResponse(ip)));
    }

    @Override
    public void isWhitelistedAsync(UUID uuid, Consumer<Boolean> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.isWhitelisted(uuid)));
    }

    @Override
    public void isWhitelistedAsync(String ip, Consumer<Boolean> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.isWhitelisted(ip)));
    }

    @Override
    public void alertsState(UUID uuid, Consumer<Boolean> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.settingsDocument.find(Filters.and(Filters.eq("setting", "alerts"), Filters.eq("uuid", uuid.toString()))).first() != null));
    }

    @Override
    public void updateAlertsState(UUID uuid, boolean state) {
        VPNExecutor.threadExecutor.execute(() -> {
            this.settingsDocument.deleteMany(Filters.and(Filters.eq("setting", "alerts"), Filters.eq("uuid", uuid.toString())));
            if (state) {
                Document adoc = new Document("setting", "alerts");
                adoc.put("uuid", (Object)uuid.toString());
                this.settingsDocument.insertOne(adoc);
            }
        });
    }

    @Override
    public void clearResponses() {
        this.cacheDocument.deleteMany(Filters.exists("ip"));
    }

    @Override
    public void init() {
        if (!AntiVPN.getInstance().getVpnConfig().mongoDatabaseURL().isEmpty()) {
            ConnectionString cs = new ConnectionString(AntiVPN.getInstance().getVpnConfig().mongoDatabaseURL());
            MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(cs).build();
            this.client = MongoClients.create(settings);
        } else {
            MongoClientSettings.Builder settingsBld = MongoClientSettings.builder().readPreference(ReadPreference.nearest()).applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(new ServerAddress(AntiVPN.getInstance().getVpnConfig().getIp(), AntiVPN.getInstance().getVpnConfig().getPort()))));
            if (AntiVPN.getInstance().getVpnConfig().useDatabaseCreds()) {
                settingsBld.credential(MongoCredential.createCredential(AntiVPN.getInstance().getVpnConfig().getUsername(), AntiVPN.getInstance().getVpnConfig().getDatabaseName(), AntiVPN.getInstance().getVpnConfig().getPassword().toCharArray()));
            }
            this.client = MongoClients.create(settingsBld.build());
        }
        MongoDatabase antivpnDatabase = this.client.getDatabase(AntiVPN.getInstance().getVpnConfig().getDatabaseName());
        this.settingsDocument = antivpnDatabase.getCollection("settings");
        if (this.settingsDocument.listIndexes().first() == null) {
            AntiVPN.getInstance().getExecutor().log("Created index for settings collection!", new Object[0]);
            this.settingsDocument.createIndex(Indexes.ascending("ip"));
        }
        this.cacheDocument = antivpnDatabase.getCollection("cache");
    }

    @Override
    public void shutdown() {
        this.settingsDocument = null;
        this.cacheDocument = null;
        this.client.close();
    }
}

