/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.message;

import dev.brighten.antivpn.api.APIPlayer;
import java.util.function.Function;

public class VpnString {
    private final String key;
    private final String defaultMessage;
    private String message;
    private Function<VpnString, String> configStringGetter;

    public VpnString(String key, String defaultMessage) {
        this.key = key;
        this.defaultMessage = defaultMessage;
    }

    public void updateString() {
        if (this.configStringGetter == null) {
            throw new Exception("The configStringGetter for string " + this.key + " is null!");
        }
        this.message = this.configStringGetter.apply(this);
    }

    public String getFormattedMessage(Var<String, Object> ... replacements) {
        String formatted = this.configStringGetter.apply(this);
        for (Var<String, Object> replacement : replacements) {
            formatted = formatted.replace("%" + replacement.getKey() + "%", replacement.getReplacement().toString());
        }
        return formatted;
    }

    public void sendMessage(APIPlayer player, Var<String, Object> ... replacements) {
        String formatted = this.message;
        for (Var<String, Object> replacement : replacements) {
            formatted = formatted.replace("%" + replacement.getKey() + "%", replacement.getReplacement().toString());
        }
        player.sendMessage(formatted);
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public Function<VpnString, String> getConfigStringGetter() {
        return this.configStringGetter;
    }

    public void setConfigStringGetter(Function<VpnString, String> configStringGetter) {
        this.configStringGetter = configStringGetter;
    }

    public static class Var<S, O> {
        private final String key;
        private final Object replacement;

        public String getKey() {
            return this.key;
        }

        public Object getReplacement() {
            return this.replacement;
        }

        public Var(String key, Object replacement) {
            this.key = key;
            this.replacement = replacement;
        }
    }
}

