/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.shaded.org.h2.expression.function;

import dev.brighten.antivpn.shaded.org.h2.engine.SessionLocal;
import dev.brighten.antivpn.shaded.org.h2.expression.Expression;
import dev.brighten.antivpn.shaded.org.h2.expression.ExpressionVisitor;
import dev.brighten.antivpn.shaded.org.h2.expression.function.Function0_1;
import dev.brighten.antivpn.shaded.org.h2.message.DbException;
import dev.brighten.antivpn.shaded.org.h2.util.MathUtils;
import dev.brighten.antivpn.shaded.org.h2.value.TypeInfo;
import dev.brighten.antivpn.shaded.org.h2.value.Value;
import dev.brighten.antivpn.shaded.org.h2.value.ValueDouble;
import dev.brighten.antivpn.shaded.org.h2.value.ValueNull;
import dev.brighten.antivpn.shaded.org.h2.value.ValueUuid;
import dev.brighten.antivpn.shaded.org.h2.value.ValueVarbinary;
import java.util.Random;

public final class RandFunction
extends Function0_1 {
    public static final int RAND = 0;
    public static final int SECURE_RAND = 1;
    public static final int RANDOM_UUID = 2;
    private static final String[] NAMES = new String[]{"RAND", "SECURE_RAND", "RANDOM_UUID"};
    private final int function;

    public RandFunction(Expression expression, int n) {
        super(expression);
        this.function = n;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value;
        if (this.arg != null) {
            value = this.arg.getValue(sessionLocal);
            if (value == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
        } else {
            value = null;
        }
        switch (this.function) {
            case 0: {
                Random random = sessionLocal.getRandom();
                if (value != null) {
                    random.setSeed(value.getInt());
                }
                value = ValueDouble.get(random.nextDouble());
                break;
            }
            case 1: {
                value = ValueVarbinary.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                break;
            }
            case 2: {
                value = ValueUuid.getNewRandom();
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return value;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        if (this.arg != null) {
            this.arg = this.arg.optimize(sessionLocal);
        }
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case 1: {
                Value value;
                this.type = this.arg.isConstant() && (value = this.arg.getValue(sessionLocal)) != ValueNull.INSTANCE ? TypeInfo.getTypeInfo(6, Math.max(value.getInt(), 1), 0, null) : TypeInfo.TYPE_VARBINARY;
                break;
            }
            case 2: {
                this.type = TypeInfo.TYPE_UUID;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                return false;
            }
        }
        return super.isEverything(expressionVisitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

