/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;

public class MiscUtils {
    private static final Pattern ipv4 = Pattern.compile("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}");

    public static void close(Closeable ... closeables) {
        try {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(AutoCloseable ... closeables) {
        try {
            for (AutoCloseable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copy(InputStream in, File file) {
        try {
            int lenght;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((lenght = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, lenght);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ThreadFactory createThreadFactory(String threadName) {
        return r -> {
            Thread thread = new Thread(r);
            thread.setName(threadName);
            return thread;
        };
    }

    public static boolean isIpv4(String ip) {
        return ipv4.matcher(ip).matches();
    }
}

