/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.utils.config;

import dev.brighten.antivpn.shaded.org.yaml.snakeyaml.DumperOptions;
import dev.brighten.antivpn.shaded.org.yaml.snakeyaml.LoaderOptions;
import dev.brighten.antivpn.shaded.org.yaml.snakeyaml.Yaml;
import dev.brighten.antivpn.shaded.org.yaml.snakeyaml.constructor.Constructor;
import dev.brighten.antivpn.shaded.org.yaml.snakeyaml.representer.Representer;
import dev.brighten.antivpn.utils.config.Configuration;
import dev.brighten.antivpn.utils.config.ConfigurationProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class YamlConfiguration
extends ConfigurationProvider {
    private final ThreadLocal<Yaml> yaml = new ThreadLocal<Yaml>(){

        @Override
        protected Yaml initialValue() {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Representer representer = new Representer(options){
                {
                    this.representers.put(Configuration.class, data -> this.represent(((Configuration)data).self));
                }
            };
            representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            return new Yaml(new Constructor(new LoaderOptions()), representer, options);
        }
    };

    @Override
    public void save(Configuration config, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            this.save(config, writer);
        }
    }

    @Override
    public void save(Configuration config, Writer writer) {
        String contents = this.yaml.get().dump(config.self);
        if (contents.equals("{}\n")) {
            contents = "";
        }
        ArrayList list = new ArrayList();
        Collections.addAll(list, contents.split("\n"));
        int currentLayer = 0;
        StringBuilder currentPath = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        int lineNumber = 0;
        for (String line : list) {
            sb.append(line);
            sb.append('\n');
            if (!line.isEmpty() && line.contains(":")) {
                int layerFromLine = config.getLayerFromLine(line, lineNumber);
                if (layerFromLine < currentLayer) {
                    currentPath = new StringBuilder(config.regressPathBy(currentLayer - layerFromLine, currentPath.toString()));
                }
                String key = config.getKeyFromLine(line);
                if (currentLayer == 0) {
                    currentPath = new StringBuilder(key);
                } else {
                    currentPath.append("." + key);
                }
                String path = currentPath.toString();
                if (config.comments.containsKey(path)) {
                    config.comments.get(path).forEach(string -> {
                        sb.append((String)string);
                        sb.append('\n');
                    });
                }
            }
            ++lineNumber;
        }
        try {
            writer.write(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Configuration load(File file) throws IOException {
        return this.load(file, null);
    }

    @Override
    public Configuration load(File file, Configuration defaults) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Configuration configuration = this.load(is, defaults);
            return configuration;
        }
    }

    @Override
    public Configuration load(Reader reader) {
        return this.load(reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration load(Reader reader, Configuration defaults) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        return this.load(builder.toString(), defaults);
    }

    @Override
    public Configuration load(InputStream is) {
        return this.load(new InputStreamReader(is, Charset.defaultCharset()));
    }

    @Override
    public Configuration load(InputStream is, Configuration defaults) {
        return this.load(new InputStreamReader(is, Charset.defaultCharset()), defaults);
    }

    @Override
    public Configuration load(String string) {
        return this.load(string, null);
    }

    @Override
    public Configuration load(String contents, Configuration defaults) {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setMaxAliasesForCollections(Integer.MAX_VALUE);
        Map map = this.yaml.get().loadAs(contents, LinkedHashMap.class);
        Configuration config = new Configuration(map, defaults);
        config.loadFromString(contents);
        return config;
    }

    YamlConfiguration() {
    }
}

