/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.scheduler.ScheduledTask;
import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.VPNExecutor;
import dev.brighten.antivpn.shaded.com.google.common.cache.Cache;
import dev.brighten.antivpn.shaded.com.google.common.cache.CacheBuilder;
import dev.brighten.antivpn.velocity.VelocityPlugin;
import dev.brighten.antivpn.velocity.util.StringUtils;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class VelocityListener
extends VPNExecutor {
    private ScheduledTask cacheResetTask;
    private final Cache<UUID, VPNResponse> responseCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(2000L).build();

    @Override
    public void registerListeners() {
        VelocityPlugin.INSTANCE.getServer().getEventManager().register((Object)VelocityPlugin.INSTANCE, (Object)this);
        VelocityPlugin.INSTANCE.getServer().getEventManager().register((Object)VelocityPlugin.INSTANCE, DisconnectEvent.class, event -> AntiVPN.getInstance().getPlayerExecutor().unloadPlayer(event.getPlayer().getUniqueId()));
        VelocityPlugin.INSTANCE.getServer().getEventManager().register((Object)VelocityPlugin.INSTANCE, LoginEvent.class, event -> {
            if (event.getResult().isAllowed()) {
                VPNResponse cached;
                if (event.getPlayer().hasPermission("antivpn.bypass") || AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getUniqueId()) || AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getRemoteAddress().getAddress().getHostAddress()) || AntiVPN.getInstance().getVpnConfig().getPrefixWhitelists().stream().anyMatch(prefix -> event.getPlayer().getUsername().startsWith((String)prefix))) {
                    return;
                }
                if (this.responseCache.asMap().containsKey(event.getPlayer().getUniqueId()) && (cached = this.responseCache.getIfPresent(event.getPlayer().getUniqueId())) != null && cached.isProxy()) {
                    event.setResult(ResultedEvent.ComponentResult.denied((Component)Component.text((String)"No")));
                    return;
                }
                this.checkIp(event.getPlayer().getRemoteAddress().getAddress().getHostAddress(), AntiVPN.getInstance().getVpnConfig().cachedResults(), result -> {
                    if (result.isSuccess()) {
                        if (!(AntiVPN.getInstance().getVpnConfig().countryList().isEmpty() || AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getUniqueId()) || AntiVPN.getInstance().getExecutor().isWhitelisted(event.getPlayer().getRemoteAddress().getAddress().getHostAddress()) || AntiVPN.getInstance().getVpnConfig().countryList().contains(result.getCountryCode()) == AntiVPN.getInstance().getVpnConfig().whitelistCountries())) {
                            if (AntiVPN.getInstance().getVpnConfig().countryKickCommands().isEmpty()) {
                                String kickReason = AntiVPN.getInstance().getVpnConfig().countryVanillaKickReason();
                                event.setResult(ResultedEvent.ComponentResult.denied((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(kickReason.replace("%player%", event.getPlayer().getUsername()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode()))));
                                VelocityPlugin.INSTANCE.getServer().getScheduler().buildTask((Object)VelocityPlugin.INSTANCE, () -> event.getPlayer().disconnect((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(kickReason.replace("%player%", event.getPlayer().getUsername()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode()))));
                            } else {
                                for (String cmd : AntiVPN.getInstance().getVpnConfig().countryKickCommands()) {
                                    String formattedCommand = StringUtils.translateAlternateColorCodes('&', cmd.replace("%player%", event.getPlayer().getUsername()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode()));
                                    VelocityPlugin.INSTANCE.getServer().getCommandManager().executeAsync((CommandSource)VelocityPlugin.INSTANCE.getServer().getConsoleCommandSource(), StringUtils.translateAlternateColorCodes('&', formattedCommand));
                                }
                            }
                        } else if (result.isProxy()) {
                            if (AntiVPN.getInstance().getVpnConfig().kickPlayersOnDetect()) {
                                event.setResult(ResultedEvent.ComponentResult.denied((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(AntiVPN.getInstance().getVpnConfig().getKickString().replace("%player%", event.getPlayer().getUsername()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode()))));
                                VelocityPlugin.INSTANCE.getServer().getScheduler().buildTask((Object)VelocityPlugin.INSTANCE, () -> event.getPlayer().disconnect((Component)LegacyComponentSerializer.builder().character('&').build().deserialize(AntiVPN.getInstance().getVpnConfig().getKickString().replace("%player%", event.getPlayer().getUsername()).replace("%country%", result.getCountryName()).replace("%code%", result.getCountryCode())))).delay(1L, TimeUnit.SECONDS).schedule();
                            }
                            VelocityPlugin.INSTANCE.getLogger().info(event.getPlayer().getUsername() + " joined on a VPN/Proxy (" + result.getMethod() + ")");
                            if (AntiVPN.getInstance().getVpnConfig().alertToStaff()) {
                                AntiVPN.getInstance().getPlayerExecutor().getOnlinePlayers().stream().filter(APIPlayer::isAlertsEnabled).forEach(pl -> pl.sendMessage(AntiVPN.getInstance().getVpnConfig().alertMessage().replace("%player%", event.getPlayer().getUsername()).replace("%reason%", result.getMethod()).replace("%country%", result.getCountryName()).replace("%city%", result.getCity())));
                            }
                            if (AntiVPN.getInstance().getVpnConfig().runCommands()) {
                                for (String command : AntiVPN.getInstance().getVpnConfig().commands()) {
                                    VelocityPlugin.INSTANCE.getServer().getCommandManager().executeAsync((CommandSource)VelocityPlugin.INSTANCE.getServer().getConsoleCommandSource(), StringUtils.translateAlternateColorCodes('&', command.replace("%player%", event.getPlayer().getUsername())));
                                }
                            }
                            ++AntiVPN.getInstance().detections;
                        }
                    } else {
                        VelocityPlugin.INSTANCE.getLogger().log(Level.WARNING, "The API query was not a success! You may need to upgrade your license on https://funkemunky.cc/shop");
                    }
                    ++AntiVPN.getInstance().checked;
                });
            }
        });
    }

    @Override
    public void shutdown() {
        if (this.cacheResetTask != null) {
            this.cacheResetTask.cancel();
            this.cacheResetTask = null;
        }
        threadExecutor.shutdown();
        VelocityPlugin.INSTANCE.getServer().getEventManager().unregisterListener((Object)VelocityPlugin.INSTANCE, (Object)this);
    }

    @Override
    public void log(Level level, String log, Object ... objects) {
        VelocityPlugin.INSTANCE.getLogger().log(level, String.format(log, objects));
    }

    @Override
    public void log(String log, Object ... objects) {
        this.log(Level.INFO, String.format(log, objects), new Object[0]);
    }

    @Override
    public void logException(String message, Exception ex) {
        VelocityPlugin.INSTANCE.getLogger().log(Level.SEVERE, message, ex);
    }
}

