/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.web.objects;

import dev.brighten.antivpn.utils.json.JSONException;
import dev.brighten.antivpn.utils.json.JSONObject;

public class VPNResponse {
    private String asn;
    private String ip;
    private String countryName;
    private String countryCode;
    private String city;
    private String timeZone;
    private String method;
    private String isp;
    private String failureReason = "N/A";
    private boolean proxy;
    private boolean cached;
    private final boolean success;
    private double latitude;
    private double longitude;
    private long lastAccess;
    private long queriesLeft;
    public static final VPNResponse FAILED_RESPONSE = VPNResponse.builder().success(false).failureReason("Internal plugin API error.").build();

    public JSONObject toJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("ip", this.ip);
        json.put("countryName", this.countryName);
        json.put("countryCode", this.countryCode);
        json.put("city", this.city);
        json.put("method", this.method);
        json.put("isp", this.isp);
        json.put("proxy", this.proxy);
        json.put("success", this.success);
        json.put("timeZone", this.timeZone);
        json.put("queriesLeft", this.queriesLeft);
        json.put("cached", this.cached);
        return json;
    }

    public static VPNResponse fromJson(String json) throws JSONException {
        return VPNResponse.fromJson(new JSONObject(json));
    }

    public static VPNResponse fromJson(JSONObject jsonObject) throws JSONException {
        if (jsonObject.getBoolean("success")) {
            return new VPNResponse(jsonObject.getString("asn"), jsonObject.getString("ip"), jsonObject.getString("countryName"), jsonObject.getString("countryCode"), jsonObject.getString("city"), jsonObject.getString("timeZone"), jsonObject.has("method") ? jsonObject.getString("method") : "N/A", jsonObject.getString("isp"), "N/A", jsonObject.getBoolean("proxy"), jsonObject.getBoolean("cached"), jsonObject.getBoolean("success"), jsonObject.getDouble("latitude"), jsonObject.getDouble("longitude"), jsonObject.getLong("lastAccess"), jsonObject.getInt("queriesLeft"));
        }
        return VPNResponse.builder().success(false).failureReason(jsonObject.getString("failureReason")).build();
    }

    public static VPNResponseBuilder builder() {
        return new VPNResponseBuilder();
    }

    public String getAsn() {
        return this.asn;
    }

    public String getIp() {
        return this.ip;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getMethod() {
        return this.method;
    }

    public String getIsp() {
        return this.isp;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getQueriesLeft() {
        return this.queriesLeft;
    }

    public void setAsn(String asn) {
        this.asn = asn;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public void setQueriesLeft(long queriesLeft) {
        this.queriesLeft = queriesLeft;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VPNResponse)) {
            return false;
        }
        VPNResponse other = (VPNResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isProxy() != other.isProxy()) {
            return false;
        }
        if (this.isCached() != other.isCached()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        if (this.getLastAccess() != other.getLastAccess()) {
            return false;
        }
        if (this.getQueriesLeft() != other.getQueriesLeft()) {
            return false;
        }
        String this$asn = this.getAsn();
        String other$asn = other.getAsn();
        if (this$asn == null ? other$asn != null : !this$asn.equals(other$asn)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$countryName = this.getCountryName();
        String other$countryName = other.getCountryName();
        if (this$countryName == null ? other$countryName != null : !this$countryName.equals(other$countryName)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$isp = this.getIsp();
        String other$isp = other.getIsp();
        if (this$isp == null ? other$isp != null : !this$isp.equals(other$isp)) {
            return false;
        }
        String this$failureReason = this.getFailureReason();
        String other$failureReason = other.getFailureReason();
        return !(this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VPNResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProxy() ? 79 : 97);
        result = result * 59 + (this.isCached() ? 79 : 97);
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        long $lastAccess = this.getLastAccess();
        result = result * 59 + (int)($lastAccess >>> 32 ^ $lastAccess);
        long $queriesLeft = this.getQueriesLeft();
        result = result * 59 + (int)($queriesLeft >>> 32 ^ $queriesLeft);
        String $asn = this.getAsn();
        result = result * 59 + ($asn == null ? 43 : $asn.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $countryName = this.getCountryName();
        result = result * 59 + ($countryName == null ? 43 : $countryName.hashCode());
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $isp = this.getIsp();
        result = result * 59 + ($isp == null ? 43 : $isp.hashCode());
        String $failureReason = this.getFailureReason();
        result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
        return result;
    }

    public String toString() {
        return "VPNResponse(asn=" + this.getAsn() + ", ip=" + this.getIp() + ", countryName=" + this.getCountryName() + ", countryCode=" + this.getCountryCode() + ", city=" + this.getCity() + ", timeZone=" + this.getTimeZone() + ", method=" + this.getMethod() + ", isp=" + this.getIsp() + ", failureReason=" + this.getFailureReason() + ", proxy=" + this.isProxy() + ", cached=" + this.isCached() + ", success=" + this.isSuccess() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", lastAccess=" + this.getLastAccess() + ", queriesLeft=" + this.getQueriesLeft() + ")";
    }

    public VPNResponse(String asn, String ip, String countryName, String countryCode, String city, String timeZone, String method, String isp, String failureReason, boolean proxy, boolean cached, boolean success, double latitude, double longitude, long lastAccess, long queriesLeft) {
        this.asn = asn;
        this.ip = ip;
        this.countryName = countryName;
        this.countryCode = countryCode;
        this.city = city;
        this.timeZone = timeZone;
        this.method = method;
        this.isp = isp;
        this.failureReason = failureReason;
        this.proxy = proxy;
        this.cached = cached;
        this.success = success;
        this.latitude = latitude;
        this.longitude = longitude;
        this.lastAccess = lastAccess;
        this.queriesLeft = queriesLeft;
    }

    public static class VPNResponseBuilder {
        private String asn;
        private String ip;
        private String countryName;
        private String countryCode;
        private String city;
        private String timeZone;
        private String method;
        private String isp;
        private String failureReason;
        private boolean proxy;
        private boolean cached;
        private boolean success;
        private double latitude;
        private double longitude;
        private long lastAccess;
        private long queriesLeft;

        VPNResponseBuilder() {
        }

        public VPNResponseBuilder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public VPNResponseBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public VPNResponseBuilder countryName(String countryName) {
            this.countryName = countryName;
            return this;
        }

        public VPNResponseBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public VPNResponseBuilder city(String city) {
            this.city = city;
            return this;
        }

        public VPNResponseBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public VPNResponseBuilder method(String method) {
            this.method = method;
            return this;
        }

        public VPNResponseBuilder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public VPNResponseBuilder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public VPNResponseBuilder proxy(boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        public VPNResponseBuilder cached(boolean cached) {
            this.cached = cached;
            return this;
        }

        public VPNResponseBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public VPNResponseBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public VPNResponseBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public VPNResponseBuilder lastAccess(long lastAccess) {
            this.lastAccess = lastAccess;
            return this;
        }

        public VPNResponseBuilder queriesLeft(long queriesLeft) {
            this.queriesLeft = queriesLeft;
            return this;
        }

        public VPNResponse build() {
            return new VPNResponse(this.asn, this.ip, this.countryName, this.countryCode, this.city, this.timeZone, this.method, this.isp, this.failureReason, this.proxy, this.cached, this.success, this.latitude, this.longitude, this.lastAccess, this.queriesLeft);
        }

        public String toString() {
            return "VPNResponse.VPNResponseBuilder(asn=" + this.asn + ", ip=" + this.ip + ", countryName=" + this.countryName + ", countryCode=" + this.countryCode + ", city=" + this.city + ", timeZone=" + this.timeZone + ", method=" + this.method + ", isp=" + this.isp + ", failureReason=" + this.failureReason + ", proxy=" + this.proxy + ", cached=" + this.cached + ", success=" + this.success + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", lastAccess=" + this.lastAccess + ", queriesLeft=" + this.queriesLeft + ")";
        }
    }
}

