/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bukkit;

import dev.brighten.antivpn.api.APIPlayer;
import dev.brighten.antivpn.api.PlayerExecutor;
import dev.brighten.antivpn.bukkit.BukkitPlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class BukkitPlayerExecutor
implements PlayerExecutor {
    private final Map<UUID, BukkitPlayer> cachedPlayers = new HashMap<UUID, BukkitPlayer>();

    @Override
    public Optional<APIPlayer> getPlayer(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of((APIPlayer)this.cachedPlayers.computeIfAbsent(player.getUniqueId(), k -> new BukkitPlayer(player)));
    }

    @Override
    public Optional<APIPlayer> getPlayer(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of((APIPlayer)this.cachedPlayers.computeIfAbsent(player.getUniqueId(), k -> new BukkitPlayer(player)));
    }

    @Override
    public void unloadPlayer(UUID uuid) {
        this.cachedPlayers.remove(uuid);
    }

    @Override
    public List<APIPlayer> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(pl -> this.cachedPlayers.computeIfAbsent(pl.getUniqueId(), k -> new BukkitPlayer((Player)pl))).collect(Collectors.toList());
    }
}

