/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bukkit;

import dev.brighten.antivpn.bukkit.BukkitPlugin;
import dev.brighten.antivpn.utils.MiscUtils;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerCommandRunner {
    private final ScheduledExecutorService executorService;
    private final Queue<PlayerAction> playerActions = new ArrayBlockingQueue<PlayerAction>(10000);

    public PlayerCommandRunner() {
        this.executorService = Executors.newSingleThreadScheduledExecutor(MiscUtils.createThreadFactory("AntiVPN:PlayerCommandRunner"));
    }

    void start() {
        this.executorService.scheduleAtFixedRate(() -> {
            long currentTime = System.currentTimeMillis();
            while (!this.playerActions.isEmpty()) {
                final PlayerAction action = this.playerActions.peek();
                if (action == null || currentTime - action.start <= 2000L && Bukkit.getPlayer((UUID)action.getUuid()) == null) continue;
                new BukkitRunnable(){

                    public void run() {
                        action.getAction().run();
                    }
                }.runTask((Plugin)BukkitPlugin.pluginInstance);
                this.playerActions.poll();
            }
        }, 1000L, 100L, TimeUnit.MILLISECONDS);
    }

    void stop() {
        this.executorService.shutdown();
        this.playerActions.clear();
    }

    void addAction(UUID uuid, Runnable action) {
        this.playerActions.add(new PlayerAction(uuid, System.currentTimeMillis(), action));
    }

    static class PlayerAction {
        private final UUID uuid;
        private final long start;
        private final Runnable action;

        public PlayerAction(UUID uuid, long start, Runnable action) {
            this.uuid = uuid;
            this.start = start;
            this.action = action;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public long getStart() {
            return this.start;
        }

        public Runnable getAction() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerAction)) {
                return false;
            }
            PlayerAction other = (PlayerAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStart() != other.getStart()) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            Runnable this$action = this.getAction();
            Runnable other$action = other.getAction();
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlayerAction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $start = this.getStart();
            result = result * 59 + (int)($start >>> 32 ^ $start);
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            Runnable $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }

        public String toString() {
            return "PlayerCommandRunner.PlayerAction(uuid=" + String.valueOf(this.getUuid()) + ", start=" + this.getStart() + ", action=" + String.valueOf(this.getAction()) + ")";
        }
    }
}

