/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bungee;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.bungee.BungeeListener;
import dev.brighten.antivpn.bungee.BungeePlayerExecutor;
import dev.brighten.antivpn.bungee.command.BungeeCommand;
import dev.brighten.antivpn.bungee.org.bstats.bungeecord.Metrics;
import dev.brighten.antivpn.bungee.org.bstats.charts.SimplePie;
import dev.brighten.antivpn.command.Command;
import dev.brighten.antivpn.database.VPNDatabase;
import dev.brighten.antivpn.database.local.H2VPN;
import dev.brighten.antivpn.database.mongo.MongoVPN;
import dev.brighten.antivpn.database.sql.MySqlVPN;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeePlugin
extends Plugin {
    public static BungeePlugin pluginInstance;

    public void onEnable() {
        pluginInstance = this;
        this.getProxy().getLogger().info("Loading config...");
        this.getProxy().getLogger().info("Starting AntiVPN services...");
        AntiVPN.start(new BungeeListener(), new BungeePlayerExecutor(), this.getDataFolder());
        if (AntiVPN.getInstance().getVpnConfig().metrics()) {
            this.getProxy().getLogger().info("Starting bStats metrics...");
            Metrics metrics = new Metrics(this, 12616);
            metrics.addCustomChart(new SimplePie("database_used", this::getDatabaseType));
            this.getProxy().getScheduler().schedule((Plugin)this, () -> {
                AntiVPN.getInstance().detections = 0;
                AntiVPN.getInstance().checked = 0;
            }, 10L, 10L, TimeUnit.MINUTES);
        }
        for (Command command : AntiVPN.getInstance().getCommands()) {
            this.getProxy().getPluginManager().registerCommand((Plugin)pluginInstance, (net.md_5.bungee.api.plugin.Command)new BungeeCommand(command));
        }
    }

    public void onDisable() {
        AntiVPN.getInstance().stop();
    }

    private String getDatabaseType() {
        VPNDatabase database = AntiVPN.getInstance().getDatabase();
        if (database instanceof H2VPN) {
            return "H2";
        }
        if (database instanceof MySqlVPN) {
            return "MySQL";
        }
        if (database instanceof MongoVPN) {
            return "MongoDB";
        }
        return "No-Database";
    }
}

