/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.bungee.command;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.bungee.command.BungeeCommandExecutor;
import dev.brighten.antivpn.command.Command;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.TabExecutor;

public class BungeeCommand
extends net.md_5.bungee.api.plugin.Command
implements TabExecutor {
    private final Command command;

    public BungeeCommand(Command command) {
        super(command.name(), command.permission(), command.aliases());
        this.command = command;
    }

    public void execute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("antivpn.command.*") && !sender.hasPermission(this.command.permission())) {
            sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)AntiVPN.getInstance().getMessageHandler().getString("no-permission").getMessage())));
            return;
        }
        Command[] children = this.command.children();
        if (children.length > 0 && args.length > 0) {
            for (Command child : children) {
                if (!child.name().equalsIgnoreCase(args[0]) && !Arrays.stream(child.aliases()).anyMatch(alias -> alias.equalsIgnoreCase(args[0]))) continue;
                if (!sender.hasPermission("antivpn.command.*") && !sender.hasPermission(child.permission())) {
                    sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)AntiVPN.getInstance().getMessageHandler().getString("no-permission").getMessage())));
                    return;
                }
                sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)child.execute(new BungeeCommandExecutor(sender), (String[])IntStream.range(0, args.length - 1).mapToObj(i -> args[i + 1]).toArray(String[]::new)))));
                return;
            }
        }
        sender.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.command.execute(new BungeeCommandExecutor(sender), args))));
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        Command[] children = this.command.children();
        if (children.length > 0 && args.length > 0) {
            for (Command child : children) {
                if (!child.name().equalsIgnoreCase(args[0]) && !Arrays.stream(child.aliases()).anyMatch(alias2 -> alias2.equalsIgnoreCase(args[0]))) continue;
                return child.tabComplete(new BungeeCommandExecutor(sender), "alias", (String[])IntStream.range(0, args.length - 1).mapToObj(i -> args[i + 1]).toArray(String[]::new));
            }
        }
        return this.command.tabComplete(new BungeeCommandExecutor(sender), "alias", args);
    }
}

