/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.command.impl;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.command.Command;
import dev.brighten.antivpn.command.CommandExecutor;
import dev.brighten.antivpn.command.impl.AlertsCommand;
import dev.brighten.antivpn.command.impl.AllowlistCommand;
import dev.brighten.antivpn.command.impl.ClearCacheCommand;
import dev.brighten.antivpn.command.impl.LookupCommand;
import dev.brighten.antivpn.command.impl.PlanCommand;
import dev.brighten.antivpn.command.impl.ReloadCommand;
import dev.brighten.antivpn.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AntiVPNCommand
extends Command {
    @Override
    public String permission() {
        return "antivpn.command";
    }

    @Override
    public String name() {
        return "antivpn";
    }

    @Override
    public String[] aliases() {
        return new String[]{"kaurivpn", "kvpn", "vpn", "avpn"};
    }

    @Override
    public String description() {
        return "The main help command";
    }

    @Override
    public String usage() {
        return "";
    }

    @Override
    public String parent() {
        return "";
    }

    @Override
    public Command[] children() {
        return new Command[]{new LookupCommand(), new AllowlistCommand(), new AlertsCommand(), new ClearCacheCommand(), new PlanCommand(), new ReloadCommand()};
    }

    @Override
    public String execute(CommandExecutor uuid, String[] args) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(StringUtil.line("&8"));
        messages.add("&6&lAntiVPN Help Page");
        messages.add("");
        for (Command cmd : AntiVPN.getInstance().getCommands()) {
            messages.add(String.format("&8/&f%s &8- &7&o%s", "&7" + cmd.parent() + (cmd.parent().length() > 0 ? " " : "") + "&f" + cmd.name() + " &7" + cmd.usage(), cmd.description()));
        }
        for (Command child : this.children()) {
            messages.add(String.format("&8/&f%s &8- &7&o%s", "&7" + child.parent() + (child.parent().length() > 0 ? " " : "") + "&f" + child.name() + " &7" + child.usage(), child.description()));
        }
        messages.add(StringUtil.line("&8"));
        return String.join((CharSequence)"\n", messages);
    }

    @Override
    public List<String> tabComplete(CommandExecutor executor, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.stream(this.children()).map(Command::name).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

