/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.database.mongo;

import dev.brighten.antivpn.AntiVPN;
import dev.brighten.antivpn.api.VPNExecutor;
import dev.brighten.antivpn.database.VPNDatabase;
import dev.brighten.antivpn.shaded.com.github.benmanes.caffeine.cache.Cache;
import dev.brighten.antivpn.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import dev.brighten.antivpn.shaded.com.mongodb.ConnectionString;
import dev.brighten.antivpn.shaded.com.mongodb.MongoClientSettings;
import dev.brighten.antivpn.shaded.com.mongodb.MongoCredential;
import dev.brighten.antivpn.shaded.com.mongodb.ReadPreference;
import dev.brighten.antivpn.shaded.com.mongodb.ServerAddress;
import dev.brighten.antivpn.shaded.com.mongodb.client.MongoClient;
import dev.brighten.antivpn.shaded.com.mongodb.client.MongoClients;
import dev.brighten.antivpn.shaded.com.mongodb.client.MongoCollection;
import dev.brighten.antivpn.shaded.com.mongodb.client.MongoDatabase;
import dev.brighten.antivpn.shaded.com.mongodb.client.model.Filters;
import dev.brighten.antivpn.shaded.com.mongodb.client.model.Indexes;
import dev.brighten.antivpn.shaded.com.mongodb.client.model.UpdateOptions;
import dev.brighten.antivpn.shaded.org.bson.Document;
import dev.brighten.antivpn.shaded.org.bson.conversions.Bson;
import dev.brighten.antivpn.web.objects.VPNResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class MongoVPN
implements VPNDatabase {
    private MongoCollection<Document> settingsDocument;
    private MongoCollection<Document> cacheDocument;
    private MongoClient client;
    private final Cache<String, VPNResponse> cachedResponses = Caffeine.newBuilder().expireAfterWrite(20L, TimeUnit.MINUTES).maximumSize(4000L).build();

    public MongoVPN() {
        VPNExecutor.threadExecutor.scheduleAtFixedRate(() -> {
            if (!AntiVPN.getInstance().getVpnConfig().isDatabaseEnabled()) {
                return;
            }
            AntiVPN.getInstance().getExecutor().getWhitelisted().clear();
            AntiVPN.getInstance().getExecutor().getWhitelisted().addAll(AntiVPN.getInstance().getDatabase().getAllWhitelisted());
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().clear();
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().addAll(AntiVPN.getInstance().getDatabase().getAllWhitelistedIps());
        }, 2L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public Optional<VPNResponse> getStoredResponse(String ip) {
        VPNResponse response = (VPNResponse)this.cachedResponses.get((Object)ip, ip2 -> {
            Document rdoc = (Document)this.cacheDocument.find(Filters.eq((String)"ip", (Object)ip)).first();
            if (rdoc != null) {
                long lastUpdate = (Long)rdoc.get((Object)"lastAccess", (Object)0L);
                if (System.currentTimeMillis() - lastUpdate > TimeUnit.HOURS.toMillis(1L)) {
                    VPNExecutor.threadExecutor.execute(() -> this.deleteResponse(ip));
                    return null;
                }
                return VPNResponse.builder().asn(rdoc.getString((Object)"asn")).ip(ip).countryName(rdoc.getString((Object)"countryName")).countryCode(rdoc.getString((Object)"countryCode")).city(rdoc.getString((Object)"city")).isp(rdoc.getString((Object)"isp")).method(rdoc.getString((Object)"method")).timeZone(rdoc.getString((Object)"timeZone")).proxy(rdoc.getBoolean((Object)"proxy")).cached(rdoc.getBoolean((Object)"cached")).success(true).latitude(rdoc.getDouble((Object)"latitude")).longitude(rdoc.getDouble((Object)"longitude")).lastAccess((Long)rdoc.get((Object)"lastAccess", (Object)0L)).build();
            }
            return null;
        });
        return Optional.ofNullable(response);
    }

    @Override
    public void cacheResponse(VPNResponse toCache) {
        Document rdoc = new Document("ip", (Object)toCache.getIp());
        rdoc.put("asn", (Object)toCache.getAsn());
        rdoc.put("countryName", (Object)toCache.getCountryName());
        rdoc.put("countryCode", (Object)toCache.getCountryCode());
        rdoc.put("city", (Object)toCache.getCity());
        rdoc.put("isp", (Object)toCache.getIsp());
        rdoc.put("method", (Object)toCache.getMethod());
        rdoc.put("timeZone", (Object)toCache.getTimeZone());
        rdoc.put("proxy", (Object)toCache.isProxy());
        rdoc.put("cached", (Object)toCache.isCached());
        rdoc.put("success", (Object)toCache.isSuccess());
        rdoc.put("latitude", (Object)toCache.getLatitude());
        rdoc.put("longitude", (Object)toCache.getLongitude());
        rdoc.put("lastAccess", (Object)System.currentTimeMillis());
        this.cachedResponses.put((Object)toCache.getIp(), (Object)toCache);
        VPNExecutor.threadExecutor.execute(() -> {
            Document update = new Document("$set", (Object)rdoc);
            this.cacheDocument.updateOne(Filters.eq((String)"ip", (Object)toCache.getIp()), (Bson)update, new UpdateOptions().upsert(true));
        });
    }

    @Override
    public void deleteResponse(String ip) {
        this.cacheDocument.deleteMany(Filters.eq((String)"ip", (Object)ip));
    }

    @Override
    public boolean isWhitelisted(UUID uuid) {
        return this.settingsDocument.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"whitelist"), Filters.eq((String)"uuid", (Object)uuid.toString())})).first() != null;
    }

    @Override
    public boolean isWhitelisted(String ip) {
        return this.settingsDocument.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"whitelist"), Filters.eq((String)"ip", (Object)ip)})).first() != null;
    }

    @Override
    public void setWhitelisted(UUID uuid, boolean whitelisted) {
        if (whitelisted) {
            Document wdoc = new Document("setting", (Object)"whitelist");
            wdoc.put("uuid", (Object)uuid.toString());
            AntiVPN.getInstance().getExecutor().getWhitelisted().add(uuid);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.insertOne((Object)wdoc));
        } else {
            AntiVPN.getInstance().getExecutor().getWhitelisted().remove(uuid);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"whitelist"), Filters.eq((String)"uuid", (Object)uuid.toString())})));
        }
    }

    @Override
    public void setWhitelisted(String ip, boolean whitelisted) {
        if (whitelisted) {
            Document wdoc = new Document("setting", (Object)"whitelist").append("ip", (Object)ip);
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().add(ip);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.insertOne((Object)wdoc));
        } else {
            AntiVPN.getInstance().getExecutor().getWhitelistedIps().remove(ip);
            VPNExecutor.threadExecutor.execute(() -> this.settingsDocument.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"whitelist"), Filters.eq((String)"ip", (Object)ip)})));
        }
    }

    @Override
    public List<UUID> getAllWhitelisted() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        this.settingsDocument.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"whitelist"), Filters.exists((String)"uuid")})).forEach(doc -> uuids.add(UUID.fromString(doc.getString((Object)"uuid"))));
        return uuids;
    }

    @Override
    public List<String> getAllWhitelistedIps() {
        ArrayList<String> ips = new ArrayList<String>();
        this.settingsDocument.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"whitelist"), Filters.exists((String)"ip")})).forEach(doc -> ips.add(doc.getString((Object)"ip")));
        return ips;
    }

    @Override
    public void getStoredResponseAsync(String ip, Consumer<Optional<VPNResponse>> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.getStoredResponse(ip)));
    }

    @Override
    public void isWhitelistedAsync(UUID uuid, Consumer<Boolean> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.isWhitelisted(uuid)));
    }

    @Override
    public void isWhitelistedAsync(String ip, Consumer<Boolean> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.isWhitelisted(ip)));
    }

    @Override
    public void alertsState(UUID uuid, Consumer<Boolean> result) {
        VPNExecutor.threadExecutor.execute(() -> result.accept(this.settingsDocument.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"alerts"), Filters.eq((String)"uuid", (Object)uuid.toString())})).first() != null));
    }

    @Override
    public void updateAlertsState(UUID uuid, boolean state) {
        VPNExecutor.threadExecutor.execute(() -> {
            this.settingsDocument.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"setting", (Object)"alerts"), Filters.eq((String)"uuid", (Object)uuid.toString())}));
            if (state) {
                Document adoc = new Document("setting", (Object)"alerts");
                adoc.put("uuid", (Object)uuid.toString());
                this.settingsDocument.insertOne((Object)adoc);
            }
        });
    }

    @Override
    public void clearResponses() {
        this.cacheDocument.deleteMany(Filters.exists((String)"ip"));
    }

    @Override
    public void init() {
        if (!AntiVPN.getInstance().getVpnConfig().mongoDatabaseURL().isEmpty()) {
            ConnectionString cs = new ConnectionString(AntiVPN.getInstance().getVpnConfig().mongoDatabaseURL());
            MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(cs).build();
            this.client = MongoClients.create((MongoClientSettings)settings);
        } else {
            MongoClientSettings.Builder settingsBld = MongoClientSettings.builder().readPreference(ReadPreference.nearest()).applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(new ServerAddress(AntiVPN.getInstance().getVpnConfig().getIp(), AntiVPN.getInstance().getVpnConfig().getPort()))));
            if (AntiVPN.getInstance().getVpnConfig().useDatabaseCreds()) {
                settingsBld.credential(MongoCredential.createCredential((String)AntiVPN.getInstance().getVpnConfig().getUsername(), (String)AntiVPN.getInstance().getVpnConfig().getDatabaseName(), (char[])AntiVPN.getInstance().getVpnConfig().getPassword().toCharArray()));
            }
            this.client = MongoClients.create((MongoClientSettings)settingsBld.build());
        }
        MongoDatabase antivpnDatabase = this.client.getDatabase(AntiVPN.getInstance().getVpnConfig().getDatabaseName());
        this.settingsDocument = antivpnDatabase.getCollection("settings");
        if (this.settingsDocument.listIndexes().first() == null) {
            AntiVPN.getInstance().getExecutor().log("Created index for settings collection!", new Object[0]);
            this.settingsDocument.createIndex(Indexes.ascending((String[])new String[]{"ip"}));
        }
        this.cacheDocument = antivpnDatabase.getCollection("cache");
    }

    @Override
    public void shutdown() {
        this.settingsDocument = null;
        this.cacheDocument = null;
        this.client.close();
    }
}

