/*
 * Decompiled with CFR 0.152.
 */
package dev.brighten.antivpn.database.sql.utils;

import dev.brighten.antivpn.database.sql.utils.ResultSetIterator;
import dev.brighten.antivpn.utils.MiscUtils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public class ExecutableStatement {
    private PreparedStatement statement;
    private int pos = 1;

    public ExecutableStatement(PreparedStatement statement) {
        this.statement = statement;
    }

    public Integer execute() {
        Integer n;
        try {
            n = this.statement.executeUpdate();
        }
        catch (Throwable throwable) {
            MiscUtils.close(this.statement);
            throw throwable;
        }
        MiscUtils.close(this.statement);
        return n;
    }

    public void execute(ResultSetIterator iterator) {
        ResultSet rs = null;
        try {
            rs = this.statement.executeQuery();
            while (rs.next()) {
                iterator.next(rs);
            }
        }
        catch (Throwable throwable) {
            MiscUtils.close(this.statement, rs);
            throw throwable;
        }
        MiscUtils.close(this.statement, rs);
    }

    public void executeSingle(ResultSetIterator iterator) {
        ResultSet rs;
        block5: {
            rs = null;
            try {
                rs = this.statement.executeQuery();
                if (rs.next()) {
                    iterator.next(rs);
                    break block5;
                }
                iterator.next(null);
            }
            catch (Throwable throwable) {
                MiscUtils.close(this.statement, rs);
                throw throwable;
            }
        }
        MiscUtils.close(this.statement, rs);
    }

    public ResultSet executeQuery() {
        return this.statement.executeQuery();
    }

    public ExecutableStatement append(Object obj) {
        this.statement.setObject(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(String obj) {
        this.statement.setString(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(UUID uuid) {
        if (uuid != null) {
            this.statement.setString(this.pos++, uuid.toString().replace("-", ""));
        } else {
            this.statement.setString(this.pos++, null);
        }
        return this;
    }

    public ExecutableStatement append(Array obj) {
        this.statement.setArray(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Integer obj) {
        this.statement.setInt(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Short obj) {
        this.statement.setShort(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Long obj) {
        this.statement.setLong(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Float obj) {
        this.statement.setFloat(this.pos++, obj.floatValue());
        return this;
    }

    public ExecutableStatement append(Double obj) {
        this.statement.setDouble(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Date obj) {
        this.statement.setDate(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Timestamp obj) {
        this.statement.setTimestamp(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Time obj) {
        this.statement.setTime(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(Blob obj) {
        this.statement.setBlob(this.pos++, obj);
        return this;
    }

    public ExecutableStatement append(byte[] obj) {
        this.statement.setBytes(this.pos++, obj);
        return this;
    }
}

